/**
 * (c) 2014 FIPS / FAO of the UN (project: fi-security-common)
 */
package org.fao.fi.security.common.utilities;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

import org.bouncycastle.util.encoders.Base64Encoder;

/**
 * Place your class / interface description here.
 *
 * History:
 *
 * ------------- --------------- -----------------------
 * Date			 Author			 Comment
 * ------------- --------------- -----------------------
 * 24 Apr 2014   Fiorellato     Creation.
 *
 * @version 1.0
 * @since 24 Apr 2014
 */
final public class EncryptionUtils {
	static private Base64Encoder BASE_64_ENCODER = new Base64Encoder();

	/**
	 * Class constructor (made private in order to avoid class instantiation)
	 */
	private EncryptionUtils() {
		super();
	}
	
	/**
	 * @param content
	 * @return
	 * @throws NoSuchAlgorithmException
	 */
	static public String getMD5Sum(String content) throws NoSuchAlgorithmException {
		return EncryptionUtils.getMD5Sum(content.getBytes());
	}
	
	/**
	 * @param content
	 * @return
	 * @throws NoSuchAlgorithmException
	 */
	static public String getMD5Sum(byte[] content) throws NoSuchAlgorithmException {
		MessageDigest complete = MessageDigest.getInstance("MD5");
		
		complete.update(content);

		return EncryptionUtils.convertToHexString(complete.digest());
	}
	
	static public String getMD5Sum(File file) throws NoSuchAlgorithmException, IOException {
		return EncryptionUtils.getMD5Sum(new FileInputStream(file));
	}
	
	static public String getMD5Sum(InputStream stream) throws NoSuchAlgorithmException, IOException {
		MessageDigest complete = MessageDigest.getInstance("MD5");

		try {
			new DigestInputStream(stream, complete);
		} finally {
			stream.close();
		}
		
		return EncryptionUtils.convertToHexString(complete.digest());
	}
	
	static private String convertToHexString(byte[] toConvert) {
		assert toConvert.length == 16 : "Result length (in bytes) should be 16 instead of " + toConvert.length;
		
		StringBuffer result = new StringBuffer();
		
		for (int i = 0; i < toConvert.length; i++) {
			result.append(Integer.toString((toConvert[i] & 0xff) + 0x100, 16).substring(1));
		}
		
		assert result.length() == 32 : "Converted result length should be 32 instead of " + result.length();
		
		return result.toString();
	}

	static public String base64PrettyPrint(byte[] bytes) throws IOException {
		return EncryptionUtils.base64PrettyPrint(EncryptionUtils.toBase64(bytes));
	}

	static public String base64PrettyPrint(String base64) throws IOException {
		StringBuilder result = new StringBuilder();
		
		int counter = 0;
		
		for(char in : base64.toCharArray()) {
			result.append(in);
			counter++;
			
			if(counter % 76 == 0)
				result.append("\n");
		}
		
		return result.toString();
	}

	static public byte[] fromBase64(String string) throws IOException {
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		
		BASE_64_ENCODER.decode(string, baos);
		
		baos.flush();
		baos.close();
		
		return baos.toByteArray();
	}

	static public String toBase64(byte[] bytes) throws IOException {
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		
		BASE_64_ENCODER.encode(bytes, 0, bytes.length, baos);
		
		baos.flush();
		baos.close();
		
		return new String(baos.toByteArray());
	}
}