/**
 * (c) 2014 FAO / UN (project: fi-security-server)
 */
package org.fao.fi.security.common.support.decryption;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;

import org.fao.fi.security.common.encryption.pgp.exceptions.KeyringException;
import org.fao.fi.security.common.services.spi.decryption.DecryptionService;

/**
 * Place your class / interface description here.
 *
 * History:
 *
 * ------------- --------------- -----------------------
 * Date			 Author			 Comment
 * ------------- --------------- -----------------------
 * 2 May 2014   Fiorellato     Creation.
 *
 * @version 1.0
 * @since 2 May 2014
 */
public class EncryptedInputStreamWrapper extends ByteArrayInputStream {
	/**
	 * Class constructor
	 *
	 * @param wrapped
	 * @param streamDecryptor
	 */
	public EncryptedInputStreamWrapper(InputStream wrapped, DecryptionService streamDecryptor) throws IOException, KeyringException, GeneralSecurityException {
		super(new byte[0]);

		ByteArrayOutputStream bufferedBytes = new ByteArrayOutputStream();
		streamDecryptor.decrypt(wrapped, bufferedBytes);
		
		this.buf = bufferedBytes.toByteArray();
		
		this.count = buf.length;
		this.pos = 0;
	}
	
	/* (non-Javadoc)
	 * @see java.io.ByteArrayInputStream#read()
	 */
	@Override
	public synchronized int read() {
		return super.read();
	}
	
	/* (non-Javadoc)
	 * @see java.io.InputStream#read(byte[])
	 */
	@Override
	public int read(byte[] b) throws IOException {
		return super.read(b);
	}
	
	/* (non-Javadoc)
	 * @see java.io.ByteArrayInputStream#read(byte[], int, int)
	 */
	@Override
	public synchronized int read(byte[] b, int off, int len) {
		return super.read(b, off, len);
	}
}
