/**
 * (c) 2014 FAO / UN (project: fi-security-client)
 */
package org.fao.fi.security.client.javax.filters;

import java.io.IOException;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.core.Response;

import org.fao.fi.security.client.providers.token.spi.TokenProducerServiceClient;
import org.fao.fi.security.common.services.exceptions.token.TokenProcessingException;
import org.fao.fi.security.common.services.spi.token.TokenExchangeConstants;
import org.fao.fi.security.common.support.token.spi.TokenProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Place your class / interface description here.
 *
 * History:
 *
 * ------------- --------------- -----------------------
 * Date			 Author			 Comment
 * ------------- --------------- -----------------------
 * 2 May 2014   Fiorellato     Creation.
 *
 * @version 1.0
 * @since 2 May 2014
 */
public class TokenSecuredRequestDecorator implements ClientRequestFilter {
	private Logger _log = LoggerFactory.getLogger(this.getClass());
	
	private TokenProducerServiceClient _tokenProviderServiceClient;
	private TokenProcessor _tokenProcessor;
	
	/**
	 * Class constructor
	 *
	 * @param tokenProviderServiceClient
	 * @param tokenProcessor
	 */
	public TokenSecuredRequestDecorator(TokenProducerServiceClient tokenProviderServiceClient, TokenProcessor tokenProcessor) {
		super();
		
		this._tokenProviderServiceClient = tokenProviderServiceClient;
		this._tokenProcessor = tokenProcessor;
	}

	/* (non-Javadoc)
	 * @see javax.ws.rs.client.ClientRequestFilter#filter(javax.ws.rs.client.ClientRequestContext)
	 */
	@Override
	public void filter(ClientRequestContext requestContext) throws IOException {
		long end, start = System.currentTimeMillis();
		try {
			this._log.info("Requesting token from remote token provider...");
			
			String token = this._tokenProviderServiceClient.requestToken();
			
			end = System.currentTimeMillis();
			
			this._log.info("Remote token has been received, extracted and processed in {} mSec.",  end - start);
			
			start = System.currentTimeMillis();
			
			this._log.info("Client-side processing received token...");
			requestContext.getHeaders().add(TokenExchangeConstants.TOKEN_HEADER, this._tokenProcessor.processAfterCreation(token));
			
			end = System.currentTimeMillis();
			
			this._log.info("Received token has been processed on the client-side in {} mSec.", end - start);
		} catch (TokenProcessingException TPe) {
			requestContext.
				abortWith(Response.status(Response.Status.BAD_REQUEST).
						  entity("Unable to retrieve or write back token header").
						  build());
		} catch(WebApplicationException WAe) {
			requestContext.abortWith(Response.status(WAe.getResponse().getStatus()).
									 entity(WAe.getMessage()).
									 build());
		}
	}
}
