/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.security.client.javax.filters;

import java.io.IOException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.core.Response;
import org.fao.fi.security.client.providers.token.spi.TokenProducerServiceClient;
import org.fao.fi.security.common.services.exceptions.token.TokenProcessingException;
import org.fao.fi.security.common.support.token.spi.TokenProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenSecuredRequestDecorator
implements ClientRequestFilter {
    private Logger _log = LoggerFactory.getLogger(this.getClass());
    private TokenProducerServiceClient _tokenProviderServiceClient;
    private TokenProcessor _tokenProcessor;

    public TokenSecuredRequestDecorator(TokenProducerServiceClient tokenProviderServiceClient, TokenProcessor tokenProcessor) {
        this._tokenProviderServiceClient = tokenProviderServiceClient;
        this._tokenProcessor = tokenProcessor;
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        long start = System.currentTimeMillis();
        try {
            this._log.info("Requesting token from remote token provider...");
            String token = this._tokenProviderServiceClient.requestToken();
            long end = System.currentTimeMillis();
            this._log.info("Remote token has been received, extracted and processed in {} mSec.", (Object)(end - start));
            start = System.currentTimeMillis();
            this._log.info("Client-side processing received token...");
            requestContext.getHeaders().add((Object)"fi-security-token", (Object)this._tokenProcessor.processAfterCreation(token));
            end = System.currentTimeMillis();
            this._log.info("Received token has been processed on the client-side in {} mSec.", (Object)(end - start));
        }
        catch (TokenProcessingException TPe) {
            requestContext.abortWith(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Unable to retrieve or write back token header").build());
        }
        catch (WebApplicationException WAe) {
            requestContext.abortWith(Response.status((int)WAe.getResponse().getStatus()).entity((Object)WAe.getMessage()).build());
        }
    }
}

