/**
 * (c) 2014 FAO / UN (project: fi-security-client)
 */
package org.fao.fi.security.client.providers.token.impl;

import java.net.URL;

import javax.ws.rs.ClientErrorException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.Invocation.Builder;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.fao.fi.security.client.providers.token.spi.TokenProducerServiceClient;
import org.fao.fi.security.common.services.exceptions.token.TokenProcessingException;
import org.fao.fi.security.common.support.token.spi.TokenProcessor;
import org.glassfish.jersey.client.ClientConfig;

/**
 * Place your class / interface description here.
 *
 * History:
 *
 * ------------- --------------- -----------------------
 * Date			 Author			 Comment
 * ------------- --------------- -----------------------
 * 2 May 2014   Fiorellato     Creation.
 *
 * @version 1.0
 * @since 2 May 2014
 */
abstract public class AbstractTokenProviderServiceClient implements TokenProducerServiceClient {
	private Client _client = null;
	
	private ClientConfig _config;
	private URL _endpoint;
	
	private TokenProcessor _tokenProcessor;
	
	public AbstractTokenProviderServiceClient(URL endpoint, TokenProcessor tokenProcessor) {
		this._config = new ClientConfig();
		
		this._endpoint = endpoint;
		this._tokenProcessor = tokenProcessor;
		
		this._client = ClientBuilder.newClient(this._config);
	}
	
	final protected Builder buildRequest() {
		return 
			this._client.
				target(this._endpoint.toString()).
				request().
				accept(MediaType.TEXT_PLAIN);
	}
	
	/* (non-Javadoc)
	 * @see org.fao.fi.security.client.providers.token.spi.TokenProducerServiceClient#requestToken()
	 */
	final public String requestToken() throws TokenProcessingException {
		return this.extractToken(this.request());
	}
	
	/* (non-Javadoc)
	 * @see org.fao.fi.security.client.providers.token.spi.TokenProducerServiceClient#request()
	 */
	@Override
	final public Response request() {
		return this.buildRequest().get();
	}
	
	/* (non-Javadoc)
	 * @see org.fao.fi.security.client.providers.token.spi.TokenProducerServiceClient#extractToken(javax.ws.rs.core.Response)
	 */
	@Override
	public String extractToken(Response response) throws TokenProcessingException {
		if(response.getStatus() == 200)
			return this._tokenProcessor.processBeforeConsumption(response.readEntity(String.class));
		
		if(response.getStatus() == 404)
			throw new NotFoundException(response);
		
		throw new ClientErrorException(response.getStatus());
	}
	
	final public void registerFilter(ClientRequestFilter toRegister) {
		this._client.register(toRegister);
	}
}
