/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.security.client.javax.filters;

import java.io.IOException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.core.Response;
import org.fao.fi.security.client.providers.token.spi.TokenProducerServiceClient;
import org.fao.fi.security.common.services.exceptions.token.TokenProcessingException;
import org.fao.fi.security.common.support.token.spi.TokenProcessor;

public class TokenSecuredRequestDecorator
implements ClientRequestFilter {
    private TokenProducerServiceClient _tokenProviderServiceClient;
    private TokenProcessor _tokenProcessor;

    public TokenSecuredRequestDecorator(TokenProducerServiceClient tokenProviderServiceClient, TokenProcessor tokenProcessor) {
        this._tokenProviderServiceClient = tokenProviderServiceClient;
        this._tokenProcessor = tokenProcessor;
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        try {
            String token = this._tokenProviderServiceClient.requestToken();
            requestContext.getHeaders().add((Object)"fi-security-token", (Object)this._tokenProcessor.processAfterCreation(token));
        }
        catch (TokenProcessingException TPe) {
            requestContext.abortWith(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Unable to retrieve or write back token header").build());
        }
        catch (WebApplicationException WAe) {
            requestContext.abortWith(Response.status((int)WAe.getResponse().getStatus()).entity((Object)WAe.getMessage()).build());
        }
    }
}

