/*
 * Decompiled with CFR 0.152.
 */
package org.acme.users;

import org.cotrix.action.Action;
import org.cotrix.action.Actions;
import org.cotrix.action.CodelistAction;
import org.cotrix.action.MainAction;
import org.cotrix.action.ResourceType;
import org.cotrix.common.CommonUtils;
import org.cotrix.domain.common.Status;
import org.cotrix.domain.dsl.Roles;
import org.cotrix.domain.dsl.Users;
import org.cotrix.domain.user.Role;
import org.cotrix.domain.user.User;
import org.junit.Assert;
import org.junit.Test;

public class UserTest {
    @Test
    public void isBuiltCorrectly() {
        Role model = Roles.role((String)"model").can((Action[])MainAction.values()).buildAsRoleFor(ResourceType.application);
        User joe = Users.user().name("joe").fullName("joe the plummer").email("joe@me.com").can((Action[])CodelistAction.values()).cannot(new Action[]{CodelistAction.LOCK}).is(new Role[]{model}).build();
        Assert.assertEquals((Object)"joe", (Object)joe.name());
        Assert.assertEquals((Object)"joe@me.com", (Object)joe.email());
        Assert.assertEquals((Object)"joe the plummer", (Object)joe.fullName());
        for (CodelistAction codelistAction : CodelistAction.values()) {
            if (!codelistAction.equals(CodelistAction.LOCK)) {
                Assert.assertTrue((boolean)joe.can((Action)codelistAction));
                continue;
            }
            Assert.assertFalse((boolean)joe.can((Action)codelistAction));
        }
        Assert.assertTrue((boolean)joe.is(model));
        for (CodelistAction codelistAction : MainAction.values()) {
            Assert.assertTrue((boolean)joe.can((Action)codelistAction));
        }
    }

    @Test
    public void canBeFluentlyConstructed() {
        String name = "name";
        Action a = Actions.action((String)"a", (String[])new String[0]);
        Role m = Roles.role((String)name).buildAsRoleFor(ResourceType.application);
        User u = Users.user().name(name).fullName("name").email("joe@me.com").build();
        u = Users.user().name(name).fullName("name").email("joe@me.com").can(new Action[]{a}).build();
        u = Users.user().name(name).fullName("name").email("joe@me.com").can(new Action[]{a}).cannot(new Action[]{a}).build();
        u = Users.user().name(name).fullName("name").email("joe@me.com").can(new Action[]{a}).is(new Role[]{m}).build();
        Assert.assertFalse((boolean)this.reveal(u).isChangeset());
        Assert.assertNull((Object)this.reveal(u).status());
        u = Users.modifyUser((User)u).email("joe@me.com").build();
        u = Users.modifyUser((User)u).email("joe@me.com").can(new Action[]{a}).build();
        u = Users.modifyUser((User)u).email("joe@me.com").can(new Action[]{a}).cannot(new Action[]{a}).build();
        u = Users.modifyUser((User)u).email("joe@me.com").can(new Action[]{a}).cannot(new Action[]{a}).is(new Role[]{m}).build();
        Assert.assertTrue((boolean)this.reveal(u).isChangeset());
        Assert.assertEquals((Object)Status.MODIFIED, (Object)this.reveal(u).status());
    }

    private User.Private reveal(User u) {
        return (User.Private)CommonUtils.reveal((Object)u, User.Private.class);
    }
}

