/*
 * Decompiled with CFR 0.152.
 */
package org.acme.codelists;

import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.acme.codelists.Fixture;
import org.cotrix.application.VersioningService;
import org.cotrix.domain.attributes.Attribute;
import org.cotrix.domain.codelist.Code;
import org.cotrix.domain.codelist.Codelist;
import org.cotrix.domain.dsl.Codes;
import org.cotrix.domain.dsl.Users;
import org.cotrix.domain.dsl.grammar.AttributeGrammar;
import org.cotrix.domain.dsl.grammar.CodeGrammar;
import org.cotrix.domain.dsl.grammar.CodelistGrammar;
import org.cotrix.domain.trait.Versioned;
import org.cotrix.domain.user.User;
import org.cotrix.domain.utils.CodeStatus;
import org.cotrix.domain.utils.Constants;
import org.cotrix.domain.utils.ManagedCode;
import org.cotrix.repository.CodelistRepository;
import org.cotrix.repository.UserRepository;
import org.cotrix.test.ApplicationTest;
import org.cotrix.test.CurrentUser;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ManagedTest
extends ApplicationTest {
    @Inject
    VersioningService versioning;
    @Inject
    CodelistRepository codelists;
    @Inject
    CurrentUser current;
    @Inject
    UserRepository users;
    Attribute attr = (Attribute)((AttributeGrammar.OptionalClause)Codes.attribute().name(Fixture.name)).build();
    Code code = (Code)((CodeGrammar.OptionalClause)((CodeGrammar.OptionalClause)Codes.code().name(Fixture.name)).attributes(new Attribute[]{this.attr})).build();
    ManagedCode managed;

    @Before
    public void setup() {
        this.managed = ManagedCode.manage((Code)this.code);
    }

    @Test
    public void accessCreationDate() {
        Assert.assertNotNull((Object)this.managed.created());
    }

    @Test
    public void accessLastUpdateDate() throws Exception {
        Assert.assertEquals((Object)this.managed.created(), (Object)this.managed.lastUpdated());
        TimeUnit.SECONDS.sleep(1L);
        Codes.reveal((Code)this.code).update(Codes.reveal((Code)((Code)((CodeGrammar.OptionalClause)Codes.modify((Code)this.code).name(Fixture.newname)).build())));
        Assert.assertNotEquals((Object)this.managed.created(), (Object)this.managed.lastUpdated());
    }

    @Test
    public void accessLastUpdateDateBy() throws Exception {
        Assert.assertNull((Object)this.managed.lastUpdatedBy());
        Codes.reveal((Code)this.code).update(Codes.reveal((Code)((Code)((CodeGrammar.OptionalClause)Codes.modify((Code)this.code).name(Fixture.newname)).build())));
        Assert.assertEquals((Object)Users.cotrix.name(), (Object)this.managed.lastUpdatedBy());
        User fifi = Users.user().name("fifi").fullName("fifi").email("fifi@invente.com").build();
        this.users.add((Object)fifi);
        this.current.set(fifi);
        Codes.reveal((Code)this.code).update(Codes.reveal((Code)((Code)((CodeGrammar.OptionalClause)Codes.modify((Code)this.code).name("oncemore")).build())));
        Assert.assertEquals((Object)fifi.name(), (Object)this.managed.lastUpdatedBy());
    }

    @Test
    public void accessOrigin() throws Exception {
        User fifi = Users.user().name("fifi").fullName("fifi").email("fifi@invente.com").build();
        this.users.add((Object)fifi);
        this.current.set(fifi);
        Assert.assertNull((Object)this.managed.originId());
        Assert.assertNull((Object)this.managed.originName());
        Codelist list = (Codelist)((CodelistGrammar.SecondClause)((CodelistGrammar.SecondClause)Codes.codelist().name(Fixture.name)).with((Object[])new Code[]{this.code})).build();
        this.codelists.add((Object)list);
        Codelist versioned = (Codelist)this.versioning.bump((Versioned)list).to(Fixture.newversion);
        ManagedCode managedVersioned = ManagedCode.manage((Code)((Code)versioned.codes().lookup(this.managed.name())));
        Assert.assertEquals((Object)this.managed.id(), (Object)managedVersioned.originId());
        Assert.assertEquals((Object)this.managed.name(), (Object)managedVersioned.originName());
    }

    @Test
    public void accessStatus() throws Exception {
        Codes.reveal((Code)this.code).update(Codes.reveal((Code)((Code)((CodeGrammar.OptionalClause)Codes.modify((Code)this.code).attributes(new Attribute[]{Constants.status((CodeStatus)CodeStatus.DELETED)})).build())));
        Assert.assertEquals((Object)CodeStatus.DELETED, (Object)this.managed.status());
    }
}

