/*
 * Decompiled with CFR 0.152.
 */
package org.acme.codelists;

import org.acme.DomainTest;
import org.acme.codelists.Fixture;
import org.cotrix.domain.attributes.Attribute;
import org.cotrix.domain.attributes.Definition;
import org.cotrix.domain.dsl.Codes;
import org.cotrix.domain.dsl.grammar.AttributeGrammar;
import org.cotrix.domain.dsl.grammar.DefinitionGrammar;
import org.cotrix.domain.memory.AttributeMS;
import org.cotrix.domain.utils.Constants;
import org.cotrix.domain.validation.Constraint;
import org.cotrix.domain.validation.Validators;
import org.cotrix.domain.values.DefaultType;
import org.cotrix.domain.values.ValueType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AttributeTest
extends DomainTest {
    Attribute untyped = (Attribute)((AttributeGrammar.OptionalClause)Codes.attribute().name(Fixture.name)).ofType(Fixture.type).value(Fixture.value).in(Fixture.language).description(Fixture.description).build();
    ValueType valuetype = Codes.valueType().defaultsTo("mydef");
    Definition def = (Definition)((DefinitionGrammar.OptionalClause)Codes.definition().name(Fixture.name)).build();
    Attribute typed = (Attribute)Codes.attribute().with(this.def).value(Fixture.value).build();

    @Before
    public void before() {
        this.untyped = this.like(this.untyped);
        this.typed = this.like(this.typed);
    }

    @Test
    public void attributesCanBeFluentlyConstructed() {
        Attribute minimalUntyped = (Attribute)((AttributeGrammar.OptionalClause)Codes.attribute().name(Fixture.name)).build();
        Assert.assertNotNull((Object)minimalUntyped.definition());
        Assert.assertNull((Object)minimalUntyped.value());
        Assert.assertNull((Object)minimalUntyped.description());
        Assert.assertEquals((Object)this.untyped.definition().name(), (Object)this.untyped.name());
        Assert.assertEquals((Object)this.untyped.definition().type(), (Object)this.untyped.type());
        Assert.assertEquals((Object)this.untyped.definition().language(), (Object)this.untyped.language());
        Definition def = (Definition)((DefinitionGrammar.OptionalClause)Codes.definition().name(Fixture.name)).valueIs(this.valuetype).build();
        Attribute minimalTyped = (Attribute)Codes.attribute().with(def).build();
        Assert.assertEquals((Object)def, (Object)minimalTyped.definition());
        Assert.assertEquals((Object)this.valuetype.defaultValue(), (Object)minimalTyped.value());
    }

    @Test
    public void changesetsCanBeFluentlyConstructed() {
        ((AttributeGrammar.OptionalClause)Codes.modify((Attribute)this.untyped).name(Fixture.name)).build();
        Codes.modify((Attribute)this.untyped).value(Fixture.value).build();
        Codes.modify((Attribute)this.untyped).ofType(Fixture.type).build();
        Codes.modify((Attribute)this.untyped).in(Fixture.language).build();
        Codes.modify((Attribute)this.untyped).description(Fixture.description).build();
        Definition newdef = (Definition)((DefinitionGrammar.OptionalClause)Codes.definition().name(Fixture.name)).build();
        Codes.modify((Attribute)this.typed).with(newdef).build();
        Codes.modifyAttribute((String)"1").with(newdef).value(Fixture.value).build();
    }

    @Test
    public void canBeCloned() {
        Attribute.State state = (Attribute.State)Codes.reveal((Attribute)this.untyped).state();
        AttributeMS clone = new AttributeMS(state);
        Assert.assertEquals((Object)clone, (Object)state);
        state = (Attribute.State)Codes.reveal((Attribute)this.typed).state();
        clone = new AttributeMS(state);
        Assert.assertEquals((Object)clone, (Object)state);
    }

    @Test
    public void canBeUpdated() {
        Attribute changesetUntyped = (Attribute)((AttributeGrammar.OptionalClause)Codes.modify((Attribute)this.untyped).name(Fixture.newname)).value(Fixture.newvalue).ofType(Fixture.newtype).in(Fixture.newlanguage).description(Fixture.newdescription).build();
        Codes.reveal((Attribute)this.untyped).update(Codes.reveal((Attribute)changesetUntyped));
        Assert.assertEquals((Object)changesetUntyped.name(), (Object)this.untyped.name());
        Assert.assertEquals((Object)changesetUntyped.value(), (Object)this.untyped.value());
        Assert.assertEquals((Object)changesetUntyped.type(), (Object)this.untyped.type());
        Assert.assertEquals((Object)changesetUntyped.language(), (Object)this.untyped.language());
        Assert.assertEquals((Object)changesetUntyped.description(), (Object)this.untyped.description());
        Definition newdef = (Definition)((DefinitionGrammar.OptionalClause)Codes.definition().name(Fixture.name2)).build();
        Attribute changesetTyped = (Attribute)Codes.modify((Attribute)this.typed).with(newdef).value(Fixture.value2).build();
        Codes.reveal((Attribute)this.typed).update(Codes.reveal((Attribute)changesetTyped));
        Assert.assertEquals((Object)changesetTyped.definition(), (Object)this.typed.definition());
        Assert.assertEquals((Object)changesetTyped.value(), (Object)this.typed.value());
    }

    @Test(expected=IllegalArgumentException.class)
    public void cannotErasetName() {
        Attribute changeset = (Attribute)((AttributeGrammar.OptionalClause)Codes.modify((Attribute)this.untyped).name(Constants.NULL_QNAME)).build();
        Codes.reveal((Attribute)this.untyped).update(Codes.reveal((Attribute)changeset));
    }

    @Test
    public void canEraseValue() {
        Attribute changeset = (Attribute)Codes.modify((Attribute)this.typed).value("__ignore__").build();
        Codes.reveal((Attribute)this.typed).update(Codes.reveal((Attribute)changeset));
        Assert.assertNull((Object)this.typed.value());
    }

    @Test
    public void canEraseDescription() {
        Attribute changeset = (Attribute)Codes.modify((Attribute)this.typed).description("__ignore__").build();
        Codes.reveal((Attribute)this.typed).update(Codes.reveal((Attribute)changeset));
        Assert.assertNull((Object)this.typed.description());
    }

    @Test(expected=IllegalArgumentException.class)
    public void canEraseType() {
        Attribute changeset = (Attribute)Codes.modify((Attribute)this.untyped).ofType(Constants.NULL_QNAME).build();
        Codes.reveal((Attribute)this.untyped).update(Codes.reveal((Attribute)changeset));
    }

    @Test
    public void canEraseLanguage() {
        Attribute changeset = (Attribute)Codes.modify((Attribute)this.untyped).in("__ignore__").build();
        Codes.reveal((Attribute)this.untyped).update(Codes.reveal((Attribute)changeset));
        Assert.assertNull((Object)this.untyped.language());
    }

    @Test(expected=IllegalArgumentException.class)
    public void cannoteViolateConstraints() {
        DefaultType newtype = Codes.valueType().with(new Constraint[]{Validators.max_length.instance(new Object[]{2})});
        Definition defChangeset = (Definition)Codes.modify((Definition)this.typed.definition()).valueIs((ValueType)newtype).build();
        Codes.reveal((Definition)this.typed.definition()).update(Codes.reveal((Definition)defChangeset));
        Attribute changeset = (Attribute)Codes.modify((Attribute)this.typed).value("12").build();
        Codes.reveal((Attribute)this.typed).update(Codes.reveal((Attribute)changeset));
        changeset = (Attribute)Codes.modify((Attribute)this.typed).value("123").build();
        Codes.reveal((Attribute)this.typed).update(Codes.reveal((Attribute)changeset));
    }
}

