/*
 * Decompiled with CFR 0.152.
 */
package org.acme.codelists;

import javax.xml.namespace.QName;
import org.acme.DomainTest;
import org.cotrix.domain.dsl.Codes;
import org.cotrix.domain.memory.NamedMS;
import org.cotrix.domain.trait.Named;
import org.cotrix.domain.trait.Status;
import org.cotrix.domain.utils.Constants;
import org.junit.Assert;
import org.junit.Test;

public class NamedTest
extends DomainTest {
    @Test
    public void namesMustBeValid() {
        NamedMS state = new NamedMS();
        try {
            state.name(null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            state.name(Codes.q((String)""));
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void namesCannotBeErased() {
        Named.Abstract e = this.like(new MyEntity(new NamedMS()));
        NamedMS mychange = new NamedMS(e.id(), Status.MODIFIED);
        mychange.name(Constants.NULL_QNAME);
        MyEntity changeset = new MyEntity(mychange);
        try {
            e.update((Named.Abstract)changeset);
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
    }

    @Test
    public void namesCanBeChanged() {
        Named.Abstract e = this.like(new MyEntity(new NamedMS()));
        NamedMS mychange = new NamedMS(e.id(), Status.MODIFIED);
        mychange.name(new QName("newname"));
        MyEntity changeset = new MyEntity(mychange);
        e.update((Named.Abstract)changeset);
        Assert.assertEquals((Object)new QName("newname"), (Object)e.name());
    }

    static class MyEntity
    extends Named.Abstract<MyEntity, NamedMS> {
        public MyEntity(NamedMS state) {
            super((Named.State)state);
        }
    }
}

