/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.security.impl;

import javax.enterprise.context.ApplicationScoped;
import org.cotrix.common.Utils;
import org.cotrix.security.InvalidCredentialsException;
import org.cotrix.security.Realm;
import org.cotrix.security.tokens.NameAndPassword;
import org.jasypt.util.password.BasicPasswordEncryptor;

@ApplicationScoped
public abstract class NativeRealm
implements Realm {
    BasicPasswordEncryptor encryptor = new BasicPasswordEncryptor();

    @Override
    public boolean supports(Object token) {
        return token instanceof NameAndPassword;
    }

    protected abstract String passwordFor(String var1);

    protected abstract void create(String var1, String var2);

    protected abstract void update(String var1, String var2);

    public void update(String name, String oldPwd, String newPwd) {
        String current = this.passwordFor(name);
        if (current == null || !this.encryptor.checkPassword(oldPwd, current)) {
            throw new InvalidCredentialsException();
        }
        this.update(name, this.encrypt(newPwd));
    }

    @Override
    public String login(Object token) {
        NameAndPassword npwd = (NameAndPassword)Utils.reveal((Object)token, NameAndPassword.class);
        String pwd = this.passwordFor(npwd.name());
        if (pwd == null) {
            return null;
        }
        if (this.encryptor.checkPassword(npwd.password(), pwd)) {
            return npwd.name();
        }
        throw new InvalidCredentialsException();
    }

    @Override
    public void add(String name, String pwd) {
        if (this.passwordFor(name) != null) {
            throw new IllegalStateException("a user '" + name + "' has already signed up");
        }
        this.create(name, this.encrypt(pwd));
    }

    String encrypt(String plain) {
        return this.encryptor.encryptPassword(plain);
    }
}

