/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.repository.impl.memory;

import java.util.Collection;
import java.util.HashSet;
import javax.annotation.Priority;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Alternative;
import org.cotrix.action.ResourceType;
import org.cotrix.domain.user.Role;
import org.cotrix.domain.user.User;
import org.cotrix.repository.Criterion;
import org.cotrix.repository.MultiQuery;
import org.cotrix.repository.Query;
import org.cotrix.repository.impl.memory.MMultiQuery;
import org.cotrix.repository.impl.memory.MemoryRepository;
import org.cotrix.repository.spi.UserQueryFactory;

@ApplicationScoped
@Alternative
@Priority(value=1)
public class MUserRepository
extends MemoryRepository<User.State>
implements UserQueryFactory {
    @Override
    public MultiQuery<User, User> allUsers() {
        return new MMultiQuery<User, User>(){

            @Override
            public Collection<? extends User> executeInMemory() {
                return MUserRepository.this.adapt(MUserRepository.this.getAll());
            }
        };
    }

    @Override
    public Query<User, User> userByName(final String name) {
        return new Query.Private<User, User>(){

            @Override
            public User execute() {
                for (User.State user : MUserRepository.this.getAll()) {
                    if (!user.name().equals(name)) continue;
                    return (User)user.entity();
                }
                return null;
            }
        };
    }

    @Override
    public MultiQuery<User, User> usersWithRole(final Role role) {
        return new MMultiQuery<User, User>(){

            @Override
            public Collection<? extends User> executeInMemory() {
                HashSet<User> matches = new HashSet<User>();
                for (User.State u : MUserRepository.this.getAll()) {
                    User user = (User)u.entity();
                    if (!user.is(role)) continue;
                    matches.add(user);
                }
                return matches;
            }
        };
    }

    @Override
    public MultiQuery<User, User> teamFor(final String codelistId) {
        return new MMultiQuery<User, User>(){

            @Override
            public Collection<? extends User> executeInMemory() {
                HashSet<User> matches = new HashSet<User>();
                for (User.State u : MUserRepository.this.getAll()) {
                    User user = (User)u.entity();
                    if (user.fingerprint().specificRolesOver(codelistId, ResourceType.codelists).isEmpty()) continue;
                    matches.add(user);
                }
                return matches;
            }
        };
    }

    @Override
    public Criterion<User> byName() {
        return new MemoryRepository.MCriterion<User>(){

            @Override
            public int compare(User o1, User o2) {
                return o1.name().compareTo(o2.name());
            }
        };
    }

    @Override
    public Criterion<User> byFullName() {
        return new MemoryRepository.MCriterion<User>(){

            @Override
            public int compare(User o1, User o2) {
                return o1.fullName().compareTo(o2.fullName());
            }
        };
    }
}

