/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.repository.impl;

import java.lang.annotation.Annotation;
import org.cotrix.common.CommonUtils;
import org.cotrix.domain.trait.BeanOf;
import org.cotrix.domain.trait.Identified;
import org.cotrix.repository.Query;
import org.cotrix.repository.Repository;
import org.cotrix.repository.UpdateAction;
import org.cotrix.repository.impl.EventProducer;
import org.cotrix.repository.spi.StateRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRepository<T extends Identified, P extends Identified.Private<P, S>, S extends Identified.Bean & BeanOf<P>>
implements Repository<T> {
    private static Logger log = LoggerFactory.getLogger(Repository.class);
    private final StateRepository<S> delegate;
    private final EventProducer producer;

    public AbstractRepository(StateRepository<S> repository, EventProducer producer) {
        CommonUtils.notNull((String)"delegate repository", repository);
        CommonUtils.notNull((String)"event producer", (Object)producer);
        this.delegate = repository;
        this.producer = producer;
    }

    @Override
    public void add(T entity) {
        CommonUtils.notNull((String)"entity", entity);
        Identified.Private implementation = (Identified.Private)this.reveal(entity);
        if (implementation.isChangeset()) {
            throw new IllegalArgumentException("entity " + this.log(entity) + "is a changeset and cannot be added");
        }
        if (this.delegate.contains(implementation.id())) {
            throw new IllegalStateException("entity " + this.log(entity) + "is already in this repository");
        }
        this.producer.additions.select(new Annotation[]{EventProducer.before}).fire(entity);
        this.delegate.add(implementation.bean());
        this.producer.additions.select(new Annotation[]{EventProducer.after}).fire(entity);
    }

    @Override
    public T lookup(String id) {
        CommonUtils.valid((String)"entity identifier", (String)id);
        Identified.Bean state = (Identified.Bean)this.delegate.lookup(id);
        if (state == null) {
            return null;
        }
        return (T)((Identified)this.reveal(((BeanOf)state).entity()));
    }

    @Override
    public <R> R get(Query<T, R> query) {
        CommonUtils.notNull((String)"query", query);
        return this.reveal((Object)query).execute();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public void update(T changeset) {
        CommonUtils.notNull((String)"changeset", changeset);
        Identified.Private implementation = (Identified.Private)this.reveal(changeset);
        if (!implementation.isChangeset()) {
            throw new IllegalArgumentException(this.log(changeset) + "is not a changeset");
        }
        Identified.Bean state = (Identified.Bean)this.delegate.lookup(implementation.id());
        if (state == null) {
            throw new IllegalStateException(this.log(changeset) + " is not in this repository, hence cannot be updated.");
        }
        Identified.Private entity = (Identified.Private)((BeanOf)state).entity();
        this.producer.updates.select(new Annotation[]{EventProducer.before}).fire(changeset);
        entity.update(implementation);
        this.producer.updates.select(new Annotation[]{EventProducer.after}).fire(changeset);
    }

    @Override
    public void update(String id, UpdateAction<T> action) {
        CommonUtils.notNull((String)"entity identifier", (Object)id);
        CommonUtils.notNull((String)"update action", action);
        T entity = this.lookup(id);
        if (entity == null) {
            throw new IllegalStateException("entity " + id + " is not in this repository, hence cannot be updated.");
        }
        this.producer.updates.select(new Annotation[]{EventProducer.before}).fire((Object)EventProducer.event(id, action));
        long time = System.currentTimeMillis();
        try {
            action.performOver(entity);
        }
        catch (Exception e) {
            CommonUtils.rethrow((String)("cannot perform " + action + " (see cause) "), (Throwable)e);
        }
        log.trace("performed {} over {} in {} ms.", new Object[]{action, this.log(entity), System.currentTimeMillis() - time});
        this.producer.updates.select(new Annotation[]{EventProducer.after}).fire((Object)EventProducer.event(id, action));
    }

    @Override
    public void remove(String id) {
        CommonUtils.valid((String)"entity identifier", (String)id);
        if (!this.delegate.contains(id)) {
            throw new IllegalStateException("entity " + id + " is not in this repository, hence cannot be removed.");
        }
        T entity = this.lookup(id);
        this.producer.removals.select(new Annotation[]{EventProducer.before}).fire(entity);
        this.delegate.remove(id);
        log.info("removed entity " + id);
        this.producer.removals.select(new Annotation[]{EventProducer.after}).fire(entity);
    }

    private <R> Query.Private<T, R> reveal(Query<T, R> query) {
        return (Query.Private)CommonUtils.reveal(query, Query.Private.class);
    }

    public <A, B> A reveal(B entity) {
        return (A)entity;
    }

    public String log(T entity) {
        return entity.id() + " (" + entity.getClass().getName() + ") ";
    }
}

