/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.repository.impl.memory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Priority;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Alternative;
import javax.xml.namespace.QName;
import org.cotrix.action.ResourceType;
import org.cotrix.common.Utils;
import org.cotrix.domain.attributes.Attribute;
import org.cotrix.domain.attributes.Definition;
import org.cotrix.domain.codelist.Code;
import org.cotrix.domain.codelist.Codelink;
import org.cotrix.domain.codelist.Codelist;
import org.cotrix.domain.codelist.CodelistLink;
import org.cotrix.domain.dsl.Codes;
import org.cotrix.domain.dsl.grammar.CodeGrammar;
import org.cotrix.domain.dsl.grammar.CodelistGrammar;
import org.cotrix.domain.memory.CodelistLinkMS;
import org.cotrix.domain.memory.DefinitionMS;
import org.cotrix.domain.trait.Named;
import org.cotrix.domain.trait.Status;
import org.cotrix.domain.user.FingerPrint;
import org.cotrix.domain.user.User;
import org.cotrix.repository.CodelistCoordinates;
import org.cotrix.repository.CodelistRepository;
import org.cotrix.repository.CodelistSummary;
import org.cotrix.repository.Criterion;
import org.cotrix.repository.MultiQuery;
import org.cotrix.repository.Query;
import org.cotrix.repository.UpdateAction;
import org.cotrix.repository.impl.memory.MMultiQuery;
import org.cotrix.repository.impl.memory.MemoryRepository;
import org.cotrix.repository.spi.CodelistActionFactory;
import org.cotrix.repository.spi.CodelistQueryFactory;

@ApplicationScoped
@Alternative
@Priority(value=1)
public class MCodelistRepository
extends MemoryRepository<Codelist.State>
implements CodelistQueryFactory,
CodelistActionFactory {
    @Override
    public void remove(String id) {
        Utils.notNull((String)"identifier", (Object)id);
        for (Codelist.State list : this.getAll()) {
            for (CodelistLink.State link : list.links()) {
                if (!link.target().id().equals(id)) continue;
                throw new CodelistRepository.UnremovableCodelistException("cannot remove codelist " + list.id() + ": others depend on it");
            }
        }
        super.remove(id);
    }

    @Override
    public UpdateAction<Codelist> deleteDefinition(final String definitionId) {
        return new UpdateAction<Codelist>(){

            @Override
            public void performOver(Codelist list) {
                if (!list.definitions().contains(definitionId)) {
                    throw new IllegalArgumentException("no attribute definition " + definitionId + " in list " + list.id() + " (" + list.name() + ")");
                }
                Definition def = (Definition)list.definitions().lookup(definitionId);
                for (Code code : list.codes()) {
                    ArrayList<Attribute> changesets = new ArrayList<Attribute>();
                    for (Attribute a : code.attributes()) {
                        if (!a.definition().id().equals(def.id())) continue;
                        changesets.add(Codes.delete((Attribute)a));
                    }
                    Codes.reveal((Code)code).update(Codes.reveal((Code)((Code)((CodeGrammar.OptionalClause)Codes.modify((Code)code).attributes(changesets)).build())));
                }
                Definition.Private changeset = new DefinitionMS(def.id(), Status.DELETED).entity();
                Codes.reveal((Codelist)list).update(Codes.reveal((Codelist)((Codelist)Codes.modify((Codelist)list).definitions(new Definition[]{changeset}).build())));
            }

            public String toString() {
                return "action [delete definition " + definitionId;
            }
        };
    }

    @Override
    public UpdateAction<Codelist> deleteCodelistLink(final String linkId) {
        return new UpdateAction<Codelist>(){

            @Override
            public void performOver(Codelist list) {
                if (!list.links().contains(linkId)) {
                    throw new IllegalArgumentException("no link definition " + linkId + " in list " + list.id() + " (" + list.name() + ")");
                }
                CodelistLink type = (CodelistLink)list.links().lookup(linkId);
                for (Code code : list.codes()) {
                    ArrayList<Codelink> changesets = new ArrayList<Codelink>();
                    for (Codelink l : code.links()) {
                        if (!l.type().id().equals(type.id())) continue;
                        changesets.add(Codes.delete((Codelink)l));
                    }
                    Codes.reveal((Code)code).update(Codes.reveal((Code)((Code)((CodeGrammar.OptionalClause)Codes.modify((Code)code).links(changesets)).build())));
                }
                CodelistLink.Private changeset = new CodelistLinkMS(type.id(), Status.DELETED).entity();
                Codes.reveal((Codelist)list).update(Codes.reveal((Codelist)((Codelist)((CodelistGrammar.SecondClause)Codes.modify((Codelist)list).links((Object[])new CodelistLink[]{changeset})).build())));
            }

            public String toString() {
                return "action [delete definition " + linkId;
            }
        };
    }

    @Override
    public MultiQuery<Codelist, Codelist> allLists() {
        return new MMultiQuery<Codelist, Codelist>(){

            @Override
            Collection<Codelist> executeInMemory() {
                return MCodelistRepository.this.adapt(MCodelistRepository.this.getAll());
            }
        };
    }

    @Override
    public MultiQuery<Codelist, Code> allCodes(final String codelistId) {
        return new MMultiQuery<Codelist, Code>(){

            @Override
            public Collection<Code> executeInMemory() {
                ArrayList<Code.State> codes = new ArrayList<Code.State>();
                for (Code.State c : ((Codelist.State)MCodelistRepository.this.lookup(codelistId)).codes()) {
                    codes.add(c);
                }
                return MCodelistRepository.this.adapt(codes);
            }
        };
    }

    @Override
    public MultiQuery<Codelist, CodelistCoordinates> allListCoordinates() {
        return new MMultiQuery<Codelist, CodelistCoordinates>(){

            @Override
            public Collection<CodelistCoordinates> executeInMemory() {
                HashSet<CodelistCoordinates> coordinates = new HashSet<CodelistCoordinates>();
                for (Codelist.State list : MCodelistRepository.this.getAll()) {
                    coordinates.add(CodelistCoordinates.coordsOf(list));
                }
                return coordinates;
            }
        };
    }

    @Override
    public MultiQuery<Codelist, CodelistCoordinates> codelistsFor(User u) {
        final FingerPrint fp = u.fingerprint();
        return new MMultiQuery<Codelist, CodelistCoordinates>(){

            @Override
            public Collection<CodelistCoordinates> executeInMemory() {
                HashSet<CodelistCoordinates> coordinates = new HashSet<CodelistCoordinates>();
                for (Codelist.State list : MCodelistRepository.this.getAll()) {
                    if (fp.allRolesOver(list.id(), ResourceType.codelists).isEmpty()) continue;
                    coordinates.add(CodelistCoordinates.coordsOf(list));
                }
                return coordinates;
            }
        };
    }

    @Override
    public Query<Codelist, CodelistSummary> summary(final String id) {
        return new Query.Private<Codelist, CodelistSummary>(){

            @Override
            public CodelistSummary execute() {
                Codelist.State state = (Codelist.State)MCodelistRepository.this.lookup(id);
                if (state == null) {
                    throw new IllegalStateException("no such codelist: " + id);
                }
                Codelist list = (Codelist)state.entity();
                return new CodelistSummary(list);
            }
        };
    }

    @Override
    public Criterion<Codelist> byCodelistName() {
        return this.byName();
    }

    @Override
    public Criterion<Code> byCodeName() {
        return this.byName();
    }

    @Override
    public Criterion<CodelistCoordinates> byCoordinateName() {
        return this.byName();
    }

    private <T extends Named> Criterion<T> byName() {
        return new MemoryRepository.MCriterion<T>(){

            @Override
            public int compare(T o1, T o2) {
                return o1.name().getLocalPart().compareTo(o2.name().getLocalPart());
            }
        };
    }

    @Override
    public Criterion<Codelist> byVersion() {
        return new MemoryRepository.MCriterion<Codelist>(){

            @Override
            public int compare(Codelist o1, Codelist o2) {
                return o1.version().compareTo(o2.version());
            }
        };
    }

    @Override
    public Criterion<Code> byAttribute(final Attribute template, final int position) {
        Utils.valid((String)"attribute name", (QName)template.name());
        return new MemoryRepository.MCriterion<Code>(){

            private boolean matches(Attribute a) {
                return template.name().equals(a.name()) && (template.language() == null || template.language().equals(a.language()));
            }

            @Override
            public int compare(Code c1, Code c2) {
                int pos = 1;
                String c1Match = null;
                for (Attribute a : c1.attributes()) {
                    if (!this.matches(a)) continue;
                    if (pos == position) {
                        c1Match = a.value();
                        break;
                    }
                    ++pos;
                }
                pos = 1;
                String c2Match = null;
                for (Attribute a : c2.attributes()) {
                    if (!this.matches(a)) continue;
                    if (pos == position) {
                        c2Match = a.value();
                        break;
                    }
                    ++pos;
                }
                if (c1Match == null) {
                    return c2Match == null ? 0 : 1;
                }
                return c2Match == null ? -1 : c1Match.compareTo(c2Match);
            }
        };
    }

    @Override
    public Criterion<Code> byLink(final CodelistLink template, final int position) {
        Utils.valid((String)"link name", (QName)template.name());
        return new MemoryRepository.MCriterion<Code>(){

            private boolean matches(Codelink link) {
                return link.name().equals(template.name()) && link.type().equals(template);
            }

            @Override
            public int compare(Code c1, Code c2) {
                int pos = 1;
                List c1Match = null;
                for (Codelink link : c1.links()) {
                    if (!this.matches(link)) continue;
                    if (pos == position) {
                        c1Match = link.value();
                        break;
                    }
                    ++pos;
                }
                pos = 1;
                List c2Match = null;
                for (Codelink link : c2.links()) {
                    if (!this.matches(link)) continue;
                    if (pos == position) {
                        c2Match = link.value();
                        break;
                    }
                    ++pos;
                }
                if (c1Match == null) {
                    return c2Match == null ? 0 : 1;
                }
                if (c2Match == null) {
                    return -1;
                }
                for (int i = 0; i < Math.min(c1Match.size(), c2Match.size()); ++i) {
                    int result;
                    Object o1 = c1Match.get(i);
                    Object o2 = c2Match.get(i);
                    if (!(o1 instanceof Comparable) || (result = ((Comparable)Comparable.class.cast(o1)).compareTo(o2)) == 0) continue;
                    return result;
                }
                return c1Match.size() < c2Match.size() ? -1 : 1;
            }
        };
    }

    private static <R> MemoryRepository.MCriterion<R> revealCriterion(Criterion<R> criterion) {
        return (MemoryRepository.MCriterion)Utils.reveal(criterion, MemoryRepository.MCriterion.class);
    }
}

