/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.repository.impl;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.cotrix.domain.codelist.Codelist;
import org.cotrix.repository.CodelistRepository;
import org.cotrix.repository.impl.AbstractRepository;
import org.cotrix.repository.impl.EventProducer;
import org.cotrix.repository.spi.StateRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class BaseCodelistRepository
extends AbstractRepository<Codelist, Codelist.Private, Codelist.State>
implements CodelistRepository {
    private static Logger log = LoggerFactory.getLogger(CodelistRepository.class);

    @Inject
    public BaseCodelistRepository(StateRepository<Codelist.State> repository, EventProducer producer) {
        super(repository, producer);
    }

    @Override
    public void add(Codelist list) {
        long time = System.currentTimeMillis();
        super.add(list);
        time = System.currentTimeMillis() - time;
        log.trace("added list in {} msecs, roughly {} codes/sec", (Object)time, (Object)Float.valueOf((float)list.codes().size() / (float)time * 1000.0f));
    }

    @Override
    public void update(Codelist changeset) {
        super.update(changeset);
    }
}

