/*
 * Decompiled with CFR 0.152.
 */
package org.acme;

import java.util.Collection;
import javax.inject.Inject;
import org.cotrix.action.ResourceType;
import org.cotrix.common.Utils;
import org.cotrix.domain.dsl.Roles;
import org.cotrix.domain.dsl.Users;
import org.cotrix.domain.dsl.grammar.UserGrammar;
import org.cotrix.domain.user.Role;
import org.cotrix.domain.user.User;
import org.cotrix.repository.Query;
import org.cotrix.repository.UserQueries;
import org.cotrix.repository.UserRepository;
import org.cotrix.test.ApplicationTest;
import org.junit.Test;

public class UserRepositoryQueryTest
extends ApplicationTest {
    @Inject
    UserRepository repository;

    @Test
    public void getAllUsers() {
        User bill = this.aUser("bill").build();
        User joe = this.aUser("joe").build();
        User zoe = this.aUser("zoe").build();
        this.repository.add((Object)bill);
        this.repository.add((Object)joe);
        this.repository.add((Object)zoe);
        Iterable users = (Iterable)this.repository.get((Query)UserQueries.allUsers());
        Utils.assertEqualUnordered((Collection)Utils.collect((Iterable)users), (Object[])new Object[]{bill, joe, zoe});
    }

    @Test
    public void getRoots() {
        User bill = this.aUser("bill").isRoot().build();
        User joe = this.aUser("joe").build();
        this.repository.add((Object)bill);
        this.repository.add((Object)joe);
        Iterable users = (Iterable)this.repository.get((Query)UserQueries.usersWith((Role)Roles.ROOT));
        Utils.assertEqualUnordered((Collection)Utils.collect((Iterable)users), (Object[])new Object[]{bill});
    }

    @Test
    public void getUsersByRole() {
        Role role = this.aRole().buildAsRoleFor(ResourceType.codelists);
        User bill = this.aUser("bill").is(new Role[]{role.on("1")}).build();
        User joe = this.aUser("joe").is(new Role[]{role.on("2")}).build();
        User zoe = this.aUser("zoe").is(new Role[]{role}).build();
        this.repository.add((Object)bill);
        this.repository.add((Object)joe);
        this.repository.add((Object)zoe);
        Iterable users = (Iterable)this.repository.get((Query)UserQueries.usersWith((Role)role.on("1")));
        Utils.assertEqualUnordered((Collection)Utils.collect((Iterable)users), (Object[])new Object[]{bill, zoe});
        users = (Iterable)this.repository.get((Query)UserQueries.usersWith((Role)role));
        Utils.assertEqualUnordered((Collection)Utils.collect((Iterable)users), (Object[])new Object[]{zoe});
        users = (Iterable)this.repository.get((Query)UserQueries.teamFor((String)"1"));
        Utils.assertEqualUnordered((Collection)Utils.collect((Iterable)users), (Object[])new Object[]{bill});
    }

    @Test
    public void sortUsersByName() {
        User bill = this.aUser("bill").build();
        User joe = this.aUser("joe").build();
        User zoe = this.aUser("zoe").build();
        this.repository.add((Object)joe);
        this.repository.add((Object)zoe);
        this.repository.add((Object)bill);
        Iterable users = (Iterable)this.repository.get((Query)UserQueries.allUsers().sort(UserQueries.byName()));
        Utils.assertEqualOrdered((Collection)Utils.collect((Iterable)users), (Object[])new Object[]{bill, joe, zoe});
    }

    @Test
    public void sortUsersByFullName() {
        User y = Users.user().name("a").fullName("y").noMail().build();
        User z = Users.user().name("b").fullName("z").noMail().build();
        User x = Users.user().name("c").fullName("x").noMail().build();
        this.repository.add((Object)y);
        this.repository.add((Object)z);
        this.repository.add((Object)x);
        Iterable users = (Iterable)this.repository.get((Query)UserQueries.allUsers().sort(UserQueries.byFullName()));
        Utils.assertEqualOrdered((Collection)Utils.collect((Iterable)users), (Object[])new Object[]{x, y, z});
    }

    private UserGrammar.ThirdClause aUser(String name) {
        return Users.user().name(name).fullName(name).noMail();
    }

    private UserGrammar.ThirdClause aRole() {
        return Users.user().name("role").fullName("role").noMail();
    }
}

