/*
 * Decompiled with CFR 0.152.
 */
package org.acme;

import javax.inject.Inject;
import org.cotrix.domain.attributes.Attribute;
import org.cotrix.domain.attributes.Definition;
import org.cotrix.domain.codelist.Code;
import org.cotrix.domain.codelist.Codelink;
import org.cotrix.domain.codelist.Codelist;
import org.cotrix.domain.codelist.CodelistLink;
import org.cotrix.domain.dsl.Codes;
import org.cotrix.domain.dsl.grammar.CodeGrammar;
import org.cotrix.domain.dsl.grammar.CodelinkGrammar;
import org.cotrix.domain.dsl.grammar.CodelistGrammar;
import org.cotrix.domain.dsl.grammar.CodelistLinkGrammar;
import org.cotrix.domain.dsl.grammar.CommonClauses;
import org.cotrix.domain.dsl.grammar.DefinitionGrammar;
import org.cotrix.repository.CodelistActions;
import org.cotrix.repository.CodelistRepository;
import org.cotrix.test.ApplicationTest;
import org.junit.Assert;
import org.junit.Test;

public class CodelistRepositoryUpdateTest
extends ApplicationTest {
    @Inject
    CodelistRepository repository;

    @Test
    public void deleteAttributeDefinition() {
        Definition def = (Definition)((DefinitionGrammar.OptionalClause)Codes.definition().name("name")).build();
        Attribute attr1 = (Attribute)Codes.attribute().with(def).value("value").build();
        Attribute attr2 = (Attribute)Codes.attribute().with(def).value("value2").build();
        Code code = (Code)((CodeGrammar.OptionalClause)((CodeGrammar.OptionalClause)Codes.code().name("name")).attributes(new Attribute[]{attr1, attr2})).build();
        Codelist list = (Codelist)((CodelistGrammar.SecondClause)((CodelistGrammar.SecondClause)Codes.codelist().name("name")).definitions(new Definition[]{def}).with((Object[])new Code[]{code})).build();
        this.repository.add((Object)list);
        this.repository.update(list.id(), CodelistActions.deleteDefinition((String)def.id()));
        list = (Codelist)this.repository.lookup(list.id());
        code = (Code)list.codes().lookup(code.id());
        Assert.assertFalse((boolean)code.attributes().contains(attr1.id()));
        Assert.assertFalse((boolean)code.attributes().contains(attr2.id()));
        Assert.assertFalse((boolean)list.definitions().contains(def.id()));
    }

    @Test
    public void deleteLinkDefinition() {
        Code targetcode1 = (Code)((CodeGrammar.OptionalClause)Codes.code().name("name")).build();
        Code targetcode2 = (Code)((CodeGrammar.OptionalClause)Codes.code().name("name")).build();
        Codelist target = (Codelist)((CodelistGrammar.SecondClause)((CodelistGrammar.SecondClause)Codes.codelist().name("name")).with((Object[])new Code[]{targetcode1, targetcode2})).build();
        this.repository.add((Object)target);
        CodelistLink link = (CodelistLink)((CodelistLinkGrammar.OptionalClause)((CommonClauses.LinkTargetClause)Codes.listLink().name("name")).target((Object)target)).build();
        Codelink l1 = (Codelink)((CodelinkGrammar.OptionalClause)Codes.link().instanceOf(link).target((Object)targetcode1)).build();
        Codelink l2 = (Codelink)((CodelinkGrammar.OptionalClause)Codes.link().instanceOf(link).target((Object)targetcode2)).build();
        Code code1 = (Code)((CodeGrammar.OptionalClause)((CodeGrammar.OptionalClause)Codes.code().name("name")).links((Object[])new Codelink[]{l1})).build();
        Code code2 = (Code)((CodeGrammar.OptionalClause)((CodeGrammar.OptionalClause)Codes.code().name("name")).links((Object[])new Codelink[]{l2})).build();
        Codelist list = (Codelist)((CodelistGrammar.SecondClause)((CodelistGrammar.SecondClause)((CodelistGrammar.SecondClause)Codes.codelist().name("name")).links((Object[])new CodelistLink[]{link})).with((Object[])new Code[]{code1, code2})).build();
        this.repository.add((Object)list);
        this.repository.update(list.id(), CodelistActions.deleteCodelistLink((String)link.id()));
        list = (Codelist)this.repository.lookup(list.id());
        code1 = (Code)list.codes().lookup(code1.id());
        code2 = (Code)list.codes().lookup(code2.id());
        Assert.assertFalse((boolean)code1.links().contains(l1.id()));
        Assert.assertFalse((boolean)code2.links().contains(l2.id()));
        Assert.assertFalse((boolean)list.links().contains(link.id()));
    }
}

