/*
 * Decompiled with CFR 0.152.
 */
package org.acme;

import javax.inject.Inject;
import org.cotrix.domain.codelist.Code;
import org.cotrix.domain.codelist.Codelist;
import org.cotrix.domain.common.Attribute;
import org.cotrix.domain.dsl.Codes;
import org.cotrix.domain.dsl.grammar.AttributeGrammar;
import org.cotrix.domain.dsl.grammar.CodeGrammar;
import org.cotrix.domain.dsl.grammar.CodelistGrammar;
import org.cotrix.repository.CodelistRepository;
import org.cotrix.test.ApplicationTest;
import org.junit.Assert;
import org.junit.Test;

public class CodelistRepositoryCrudTest
extends ApplicationTest {
    @Inject
    private CodelistRepository repository;

    @Test
    public void emptyRepo() {
        Assert.assertEquals((long)0L, (long)this.repository.size());
    }

    @Test
    public void retrieveUnknownCodeList() {
        Assert.assertNull((Object)this.repository.lookup("unknown"));
    }

    @Test
    public void addCodelist() {
        int size = this.repository.size();
        Codelist list = (Codelist)((CodelistGrammar.SecondClause)Codes.codelist().name("name")).build();
        this.repository.add((Object)list);
        Assert.assertEquals((long)(size + 1), (long)this.repository.size());
        Codelist retrieved = (Codelist)this.repository.lookup(list.id());
        Assert.assertEquals((Object)list, (Object)retrieved);
    }

    @Test
    public void removeCode() {
        Code code = (Code)((CodeGrammar.SecondClause)Codes.code().name("name")).build();
        Codelist list = (Codelist)((CodelistGrammar.ThirdClause)((CodelistGrammar.SecondClause)Codes.codelist().name("name")).with((Object[])new Code[]{code})).build();
        this.repository.add((Object)list);
        Assert.assertTrue((boolean)list.codes().contains((Object)code));
        this.repository.update(((CodelistGrammar.ThirdClause)Codes.modifyCodelist((String)list.id()).with((Object[])new Code[]{Codes.deleteCode((String)code.id())})).build());
        Codelist retrieved = (Codelist)this.repository.lookup(list.id());
        Assert.assertFalse((boolean)retrieved.codes().contains((Object)code));
    }

    @Test
    public void addCode() {
        Codelist list = (Codelist)((CodelistGrammar.SecondClause)Codes.codelist().name("name")).build();
        this.repository.add((Object)list);
        list = (Codelist)this.repository.lookup(list.id());
        Code code = (Code)((CodeGrammar.SecondClause)Codes.code().name("code")).build();
        Assert.assertFalse((boolean)list.codes().contains((Object)code));
        this.repository.update(((CodelistGrammar.ThirdClause)Codes.modifyCodelist((String)list.id()).with((Object[])new Code[]{code})).build());
        Codelist retrieved = (Codelist)this.repository.lookup(list.id());
        Assert.assertTrue((boolean)retrieved.codes().contains((Object)code));
    }

    @Test
    public void updateCode() {
        Code code = (Code)((CodeGrammar.SecondClause)Codes.code().name("name")).build();
        Codelist list = (Codelist)((CodelistGrammar.ThirdClause)((CodelistGrammar.SecondClause)Codes.codelist().name("name")).with((Object[])new Code[]{code})).build();
        this.repository.add((Object)list);
        this.repository.update(((CodelistGrammar.ThirdClause)Codes.modifyCodelist((String)list.id()).with((Object[])new Code[]{(Code)((CodeGrammar.SecondClause)Codes.modifyCode((String)code.id()).name("name2")).build()})).build());
        Codelist retrieved = (Codelist)this.repository.lookup(list.id());
        Assert.assertTrue((boolean)retrieved.codes().contains(Codes.q((String)"name2")));
    }

    @Test
    public void updateAttribute() {
        Attribute a = (Attribute)((AttributeGrammar.ValueClause)Codes.attribute().name("n")).value("v").build();
        Codelist list = (Codelist)((CodelistGrammar.FinalClause)((CodelistGrammar.SecondClause)Codes.codelist().name("n")).attributes(new Attribute[]{a})).build();
        this.repository.add((Object)list);
        Attribute modified = (Attribute)Codes.modifyAttribute((String)a.id()).value("v2").build();
        Codelist changeset = (Codelist)((CodelistGrammar.FinalClause)Codes.modifyCodelist((String)list.id()).attributes(new Attribute[]{modified})).build();
        this.repository.update((Object)changeset);
        Codelist retrieved = (Codelist)this.repository.lookup(list.id());
        Assert.assertEquals((Object)((Attribute)retrieved.attributes().lookup(Codes.q((String)"n"))).value(), (Object)"v2");
    }

    @Test
    public void removeCodelist() {
        Codelist list = (Codelist)((CodelistGrammar.SecondClause)Codes.codelist().name("name")).build();
        this.repository.add((Object)list);
        int size = this.repository.size();
        this.repository.remove(list.id());
        Assert.assertEquals((long)(size - 1), (long)this.repository.size());
        Codelist retrieved = (Codelist)this.repository.lookup(list.id());
        Assert.assertNull((Object)retrieved);
    }

    @Test(expected=IllegalStateException.class)
    public void removeUnknownCodelist() {
        Codelist list = (Codelist)((CodelistGrammar.SecondClause)Codes.codelist().name("name")).build();
        this.repository.remove(list.id());
    }
}

