/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.neo.security;

import javax.annotation.Priority;
import javax.enterprise.inject.Alternative;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.cotrix.neo.domain.Constants;
import org.cotrix.security.impl.NativeRealm;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;

@Singleton
@Alternative
@Priority(value=1000)
public class NeoRealm
extends NativeRealm {
    @Inject
    private GraphDatabaseService db;

    protected String passwordFor(String name) {
        Node node = this.lookup(name);
        return node == null ? null : (String)node.getProperty("pwd");
    }

    protected void create(String name, String pwd) {
        Node identity = this.db.createNode(new Label[]{Constants.NodeType.IDENTITY});
        identity.setProperty("name", (Object)name);
        identity.setProperty("pwd", (Object)pwd);
    }

    protected void update(String name, String pwd) {
        this.lookup(name).setProperty("pwd", (Object)pwd);
    }

    private Node lookup(String name) {
        try (ResourceIterator it = this.db.findNodesByLabelAndProperty((Label)Constants.NodeType.IDENTITY, "name", (Object)name).iterator();){
            Node node = it.hasNext() ? (Node)it.next() : null;
            return node;
        }
    }
}

