/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.neo.repository;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.cotrix.repository.Range;

public class PostProcessingIterator<R>
implements Iterator<R> {
    private final Iterator<R> inner;
    private final PostProcessor<R> processor;
    private final Range range;
    private int count = 1;
    private R next = null;

    public PostProcessingIterator(Iterator<R> inner, Range range, PostProcessor<R> processor) {
        this.inner = inner;
        this.range = range;
        this.processor = processor;
    }

    private boolean inRange() {
        return this.range == Range.ALL ? true : this.count > this.range.from();
    }

    private boolean pastRange() {
        return this.range == Range.ALL ? false : this.count > this.range.to();
    }

    @Override
    public boolean hasNext() {
        R result;
        if (this.next != null) {
            return true;
        }
        while (true) {
            if (this.pastRange() || !this.inner.hasNext()) {
                return false;
            }
            result = this.inner.next();
            if (!this.processor.match(result)) continue;
            ++this.count;
            if (this.inRange()) break;
        }
        this.next = result;
        return true;
    }

    @Override
    public R next() {
        if (this.next == null && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        R returned = this.next;
        this.next = null;
        return returned;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static interface PostProcessor<R> {
        public boolean match(R var1);
    }
}

