/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.neo.repository;

import javax.annotation.Priority;
import javax.enterprise.inject.Alternative;
import javax.inject.Singleton;
import org.cotrix.common.CommonUtils;
import org.cotrix.domain.codelist.Codelist;
import org.cotrix.neo.NeoNodeFactory;
import org.cotrix.neo.NeoUtils;
import org.cotrix.neo.domain.Constants;
import org.cotrix.neo.repository.NeoQueries;
import org.cotrix.repository.UpdateAction;
import org.cotrix.repository.spi.CodelistActionFactory;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

@Singleton
@Alternative
@Priority(value=1000)
public class NeoCodelistActions
extends NeoQueries
implements CodelistActionFactory {
    public UpdateAction<Codelist> deleteLinkdef(final String linkId) {
        return new UpdateAction<Codelist>(){

            public void performOver(Codelist list) {
                if (!list.linkDefinitions().contains(linkId)) {
                    throw new IllegalArgumentException("no link definition " + linkId + " in list " + list.id() + " (" + list.qname() + ")");
                }
                Node node = NeoNodeFactory.node(Constants.NodeType.LINKDEF, linkId);
                for (Relationship instanceRelationship : node.getRelationships(Direction.INCOMING, new RelationshipType[]{Constants.Relations.INSTANCEOF})) {
                    try {
                        NeoUtils.removeNode(instanceRelationship.getStartNode());
                    }
                    catch (Exception e) {
                        CommonUtils.rethrow((String)"cannot delete link definition instance (see cause)", (Throwable)e);
                    }
                }
                try {
                    NeoUtils.removeNode(node);
                }
                catch (Exception e) {
                    CommonUtils.rethrow((String)"cannot delete link definition (see cause)", (Throwable)e);
                }
            }

            public String toString() {
                return "action [delete link definition " + linkId;
            }
        };
    }

    public UpdateAction<Codelist> deleteAttrdef(final String definitionId) {
        return new UpdateAction<Codelist>(){

            public void performOver(Codelist list) {
                if (!list.attributeDefinitions().contains(definitionId)) {
                    throw new IllegalArgumentException("no attribute definition " + definitionId + " in list " + list.id() + " (" + list.qname() + ")");
                }
                Node node = NeoNodeFactory.node(Constants.NodeType.ATTRDEF, definitionId);
                for (Relationship instanceRelationship : node.getRelationships(Direction.INCOMING, new RelationshipType[]{Constants.Relations.INSTANCEOF})) {
                    try {
                        NeoUtils.removeNode(instanceRelationship.getStartNode());
                    }
                    catch (Exception e) {
                        CommonUtils.rethrow((String)"cannot attribute definition instance (see cause)", (Throwable)e);
                    }
                }
                try {
                    NeoUtils.removeNode(node);
                }
                catch (Exception e) {
                    CommonUtils.rethrow((String)"cannot delete attribute definition (see cause)", (Throwable)e);
                }
            }

            public String toString() {
                return "action [delete attribute definition " + definitionId;
            }
        };
    }
}

