/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.neo.domain;

import java.util.Collection;
import org.cotrix.action.Action;
import org.cotrix.common.CommonUtils;
import org.cotrix.domain.trait.Identified;
import org.cotrix.domain.user.Role;
import org.cotrix.domain.user.User;
import org.cotrix.neo.domain.Constants;
import org.cotrix.neo.domain.NeoIdentified;
import org.cotrix.neo.domain.utils.NeoStateFactory;
import org.neo4j.graphdb.Node;

public class NeoUser
extends NeoIdentified
implements User.State {
    public static final NeoStateFactory<User.State> factory = new NeoStateFactory<User.State>(){

        @Override
        public User.State beanFrom(Node node) {
            return new NeoUser(node);
        }

        @Override
        public Node nodeFrom(User.State state) {
            return new NeoUser(state).node();
        }
    };

    public NeoUser(Node node) {
        super(node);
    }

    public NeoUser(User.State state) {
        super(Constants.NodeType.USER, (Identified.Bean)state);
        this.name(state.name());
        this.fullName(state.fullName());
        this.email(state.email());
        this.permissions(state.permissions());
        this.roles(state.roles());
    }

    public User.Private entity() {
        return new User.Private((User.State)this);
    }

    public String name() {
        return (String)this.node().getProperty("name");
    }

    public void name(String name) {
        this.node().setProperty("name", (Object)name.toString());
    }

    public String fullName() {
        return (String)this.node().getProperty("fullname");
    }

    public void fullName(String name) {
        this.node().setProperty("fullname", (Object)name.toString());
    }

    public String email() {
        return (String)this.node().getProperty("email");
    }

    public void email(String name) {
        this.node().setProperty("email", (Object)name.toString());
    }

    public Collection<Action> permissions() {
        return (Collection)CommonUtils.binder().fromXML((String)this.node().getProperty("permissions"));
    }

    public void permissions(Collection<Action> permissions) {
        this.node().setProperty("permissions", (Object)CommonUtils.binder().toXML(permissions));
    }

    public Collection<Role> roles() {
        return (Collection)CommonUtils.binder().fromXML((String)this.node().getProperty("roles"));
    }

    public void roles(Collection<Role> roles) {
        this.node().setProperty("roles", (Object)CommonUtils.binder().toXML(roles));
    }
}

