/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.neo.domain;

import org.cotrix.domain.attributes.Definition;
import org.cotrix.domain.codelist.Code;
import org.cotrix.domain.codelist.Codelist;
import org.cotrix.domain.codelist.CodelistLink;
import org.cotrix.domain.common.NamedStateContainer;
import org.cotrix.neo.NeoTransaction;
import org.cotrix.neo.domain.Constants;
import org.cotrix.neo.domain.NeoCode;
import org.cotrix.neo.domain.NeoCodelistLink;
import org.cotrix.neo.domain.NeoDefinition;
import org.cotrix.neo.domain.NeoVersioned;
import org.cotrix.neo.domain.utils.NeoContainer;
import org.cotrix.neo.domain.utils.NeoStateFactory;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;

public class NeoCodelist
extends NeoVersioned
implements Codelist.State {
    static final int maxBatchSize = 15000;
    public static final NeoStateFactory<Codelist.State> factory = new NeoStateFactory<Codelist.State>(){

        @Override
        public Codelist.State beanFrom(Node node) {
            return new NeoCodelist(node);
        }

        @Override
        public Node nodeFrom(Codelist.State state) {
            return new NeoCodelist(state).node();
        }
    };

    public NeoCodelist(Node node) {
        super(node);
    }

    public NeoCodelist(Codelist.State state) {
        super(Constants.NodeType.CODELIST, state);
        for (Definition.State def : state.definitions()) {
            this.node().createRelationshipTo(NeoDefinition.factory.nodeFrom(def), (RelationshipType)Constants.Relations.DEFINITION);
        }
        for (CodelistLink.State l : state.links()) {
            this.node().createRelationshipTo(NeoCodelistLink.factory.nodeFrom(l), (RelationshipType)Constants.Relations.LINK);
        }
        int i = 0;
        for (Code.State c : state.codes()) {
            if (i == 15000) {
                NeoTransaction.current().split();
                i = 0;
            }
            this.node().createRelationshipTo(NeoCode.factory.nodeFrom(c), (RelationshipType)Constants.Relations.CODE);
            ++i;
        }
    }

    public Codelist.Private entity() {
        return new Codelist.Private((Codelist.State)this);
    }

    public NamedStateContainer<Code.State> codes() {
        return new NeoContainer<Code.State>(this.node(), Constants.Relations.CODE, NeoCode.factory);
    }

    public NamedStateContainer<CodelistLink.State> links() {
        return new NeoContainer<CodelistLink.State>(this.node(), Constants.Relations.LINK, NeoCodelistLink.factory);
    }

    public NamedStateContainer<Definition.State> definitions() {
        return new NeoContainer<Definition.State>(this.node(), Constants.Relations.DEFINITION, NeoDefinition.factory);
    }
}

