/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.neo.domain;

import javax.xml.namespace.QName;
import org.cotrix.domain.codelist.Code;
import org.cotrix.domain.codelist.Codelink;
import org.cotrix.domain.codelist.CodelistLink;
import org.cotrix.domain.trait.Named;
import org.cotrix.neo.domain.Constants;
import org.cotrix.neo.domain.NeoAttributed;
import org.cotrix.neo.domain.NeoCode;
import org.cotrix.neo.domain.NeoCodelistLink;
import org.cotrix.neo.domain.utils.NeoStateFactory;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public class NeoCodelink
extends NeoAttributed
implements Codelink.State {
    public static final NeoStateFactory<Codelink.State> factory = new NeoStateFactory<Codelink.State>(){

        @Override
        public Codelink.State beanFrom(Node node) {
            return new NeoCodelink(node);
        }

        @Override
        public Node nodeFrom(Codelink.State state) {
            return new NeoCodelink(state).node();
        }
    };

    public NeoCodelink(Node node) {
        super(node);
    }

    public NeoCodelink(Codelink.State state) {
        super(Constants.NodeType.CODELINK, state);
        this.target(state.target());
        this.type(state.type());
    }

    public QName name() {
        CodelistLink.State type = this.type();
        return type == null ? null : type.name();
    }

    public void name(QName name) {
        throw new UnsupportedOperationException("codelink names are read-only");
    }

    public Codelink.Private entity() {
        return new Codelink.Private((Codelink.State)this);
    }

    public Code.State target() {
        Relationship rel = this.node().getSingleRelationship((RelationshipType)Constants.Relations.LINK, Direction.OUTGOING);
        return rel == null ? null : (Code.State)NeoCode.factory.beanFrom(rel.getEndNode());
    }

    public void target(Code.State state) {
        Relationship rel = this.node().getSingleRelationship((RelationshipType)Constants.Relations.LINK, Direction.OUTGOING);
        if (rel != null) {
            rel.delete();
        }
        this.node().createRelationshipTo(this.resolve((Named.State)state, Constants.NodeType.CODE), (RelationshipType)Constants.Relations.LINK);
    }

    public CodelistLink.State type() {
        Relationship rel = this.node().getSingleRelationship((RelationshipType)Constants.Relations.INSTANCEOF, Direction.OUTGOING);
        if (rel == null) {
            throw new IllegalStateException(this.id() + " has an orphaned codelist link");
        }
        return (CodelistLink.State)NeoCodelistLink.factory.beanFrom(rel.getEndNode());
    }

    public void type(CodelistLink.State state) {
        this.node().createRelationshipTo(this.resolve((Named.State)state, Constants.NodeType.CODELISTLINK), (RelationshipType)Constants.Relations.INSTANCEOF);
    }
}

