/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.neo;

import com.thoughtworks.xstream.XStream;
import org.cotrix.common.Utils;
import org.cotrix.neo.domain.Constants;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public class NeoUtils {
    private static XStream stream = new XStream();

    public static void removeEntityNode(Node n) {
        Utils.notNull((String)"node", (Object)n);
        if (n.hasRelationship(Direction.INCOMING)) {
            throw new IllegalStateException("entity " + n.getProperty("id") + ":" + n.getLabels() + " cannot be removed: there are other entities that link to it, directly or indirectly");
        }
        NeoUtils.removeNode(n);
    }

    public static void removeNode(Node n) {
        Utils.notNull((String)"node", (Object)n);
        for (Relationship r : n.getRelationships(Direction.OUTGOING)) {
            if (!r.isType((RelationshipType)Constants.Relations.LINK) && !r.isType((RelationshipType)Constants.Relations.INSTANCEOF)) {
                NeoUtils.removeNode(r.getEndNode());
                continue;
            }
            r.delete();
        }
        for (Relationship r : n.getRelationships(Direction.INCOMING)) {
            r.delete();
        }
        n.delete();
    }

    public static XStream binder() {
        return stream;
    }
}

