/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.neo.domain;

import javax.xml.namespace.QName;
import org.cotrix.domain.common.Attribute;
import org.cotrix.domain.trait.Identified;
import org.cotrix.neo.domain.Constants;
import org.cotrix.neo.domain.NeoIdentified;
import org.cotrix.neo.domain.utils.NeoStateFactory;
import org.neo4j.graphdb.Node;

public class NeoAttribute
extends NeoIdentified
implements Attribute.State {
    public static final NeoStateFactory<Attribute.State> factory = new NeoStateFactory<Attribute.State>(){

        @Override
        public Attribute.State beanFrom(Node node) {
            return new NeoAttribute(node);
        }

        @Override
        public Node nodeFrom(Attribute.State state) {
            return new NeoAttribute(state).node();
        }
    };

    public NeoAttribute(Node node) {
        super(node);
    }

    public NeoAttribute(Attribute.State state) {
        super(Constants.NodeType.ATTRIBUTE, (Identified.State)state);
        this.name(state.name());
        this.type(state.type());
        this.value(state.value());
        this.language(state.language());
    }

    public QName name() {
        return QName.valueOf((String)this.node().getProperty("name"));
    }

    public void name(QName name) {
        this.node().setProperty("name", (Object)name.toString());
    }

    public QName type() {
        String val = (String)this.node().getProperty("type", null);
        return val == null ? null : QName.valueOf(val);
    }

    public void type(QName type) {
        if (type == null) {
            this.node().removeProperty("type");
        } else {
            this.node().setProperty("type", (Object)type.toString());
        }
    }

    public String value() {
        return (String)this.node().getProperty("val", null);
    }

    public void value(String value) {
        if (value == null) {
            this.node().removeProperty("val");
        } else {
            this.node().setProperty("val", (Object)value);
        }
    }

    public String language() {
        return (String)this.node().getProperty("lang", null);
    }

    public void language(String language) {
        if (language == null) {
            this.node().removeProperty("lang");
        } else {
            this.node().setProperty("lang", (Object)language);
        }
    }

    public Attribute.Private entity() {
        return new Attribute.Private((Attribute.State)this);
    }
}

