/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.neo.repository;

import java.util.Collections;
import java.util.Map;
import javax.annotation.Priority;
import javax.enterprise.inject.Alternative;
import javax.inject.Inject;
import org.cotrix.neo.repository.NeoQueryEngine;
import org.neo4j.cypher.javacompat.ExecutionEngine;
import org.neo4j.cypher.javacompat.ExecutionResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alternative
@Priority(value=1000)
public class DefaultQueryEngine
implements NeoQueryEngine {
    private static Logger log = LoggerFactory.getLogger(DefaultQueryEngine.class);
    @Inject
    private ExecutionEngine engine;

    @Override
    public ExecutionResult execute(String query) {
        return this.execute(query, Collections.emptyMap());
    }

    @Override
    public ExecutionResult execute(String query, Map<String, Object> params) {
        log.info("executing Neo query {}", (Object)query);
        long time = System.currentTimeMillis();
        ExecutionResult result = this.engine.execute(query, params);
        log.info("executed Neo query {} in {} ms", (Object)query, (Object)(System.currentTimeMillis() - time));
        return result;
    }
}

