/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.lifecycle.impl;

import com.googlecode.stateless4j.StateMachine;
import java.util.Collection;
import org.cotrix.action.Action;
import org.cotrix.common.Utils;
import org.cotrix.lifecycle.LifecycleEvent;
import org.cotrix.lifecycle.State;
import org.cotrix.lifecycle.impl.AbstractLifecycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S4JLifecycle
extends AbstractLifecycle {
    private static Logger log = LoggerFactory.getLogger(S4JLifecycle.class);
    private static final long serialVersionUID = 1L;
    private final StateMachine<State, Action> machine;

    public S4JLifecycle(String name, String id, StateMachine<State, Action> machine) {
        super(name, id);
        Utils.notNull((String)"state machine", machine);
        this.machine = machine;
    }

    @Override
    public State state() {
        return (State)this.machine.getState();
    }

    @Override
    public boolean allows(Action action) {
        Utils.notNull((String)"action", (Object)action);
        return this.machine.CanFire((Object)action);
    }

    @Override
    public void notify(Action action) {
        Utils.notNull((String)"action", (Object)action);
        State origin = this.state();
        try {
            this.machine.Fire((Object)action);
        }
        catch (Exception e) {
            throw new IllegalStateException("action " + action.toString() + " is illegal for the state of this lifecycle");
        }
        State target = this.state();
        try {
            this.eventProducer().fire((Object)new LifecycleEvent(this.id, origin, action, target));
        }
        catch (Exception e) {
            log.warn("could not deliver lifecycle event", (Throwable)e);
        }
    }

    @Override
    public Collection<Action> allowed() {
        return this.machine.getPermittedTriggers();
    }
}

