/*
 * Decompiled with CFR 0.152.
 */
package org.acme;

import java.util.Arrays;
import java.util.Map;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.cotrix.action.Action;
import org.cotrix.action.CodelistAction;
import org.cotrix.lifecycle.Lifecycle;
import org.cotrix.lifecycle.LifecycleEvent;
import org.cotrix.lifecycle.LifecycleService;
import org.cotrix.lifecycle.State;
import org.cotrix.lifecycle.impl.DefaultLifecycleStates;
import org.cotrix.test.ApplicationTest;
import org.junit.Assert;
import org.junit.Test;

public class LifecycleTest
extends ApplicationTest {
    String resourceId = "resource";
    @Inject
    LifecycleService service;
    @Inject
    TestObserver observer;

    @Test
    public void startFetchAndUpdateDefaultLifecycle() {
        Lifecycle lifecycle = this.service.start(this.resourceId);
        Assert.assertEquals((Object)"resource", (Object)lifecycle.resourceId());
        Assert.assertEquals((Object)DefaultLifecycleStates.draft, (Object)lifecycle.state());
        Lifecycle retrieved = this.service.lifecycleOf(this.resourceId);
        Assert.assertEquals((Object)lifecycle, (Object)retrieved);
        retrieved.notify((Action)retrieved.allowed().iterator().next());
        this.service.update(retrieved);
        Lifecycle retrievedAfterUpdate = this.service.lifecycleOf(this.resourceId);
        Assert.assertEquals((Object)retrieved, (Object)retrievedAfterUpdate);
    }

    @Test
    public void fetchMultiple() {
        Lifecycle lc1 = this.service.start("1");
        Lifecycle lc2 = this.service.start("2");
        Map fetched = this.service.lifecyclesOf(Arrays.asList("1", "2"));
        Assert.assertEquals((Object)lc1, fetched.get("1"));
        Assert.assertEquals((Object)lc2, fetched.get("2"));
    }

    @Test
    public void startsInSealedState() {
        Lifecycle lifecycle = this.service.start("resource", (State)DefaultLifecycleStates.sealed);
        Assert.assertEquals((Object)"resource", (Object)lifecycle.resourceId());
        Assert.assertEquals((Object)DefaultLifecycleStates.sealed, (Object)lifecycle.state());
    }

    @Test(expected=IllegalArgumentException.class)
    public void createInInvalidState() {
        this.service.start("resource", new State(){});
    }

    @Test(expected=IllegalStateException.class)
    public void cannotDeleteWhenSealed() {
        Lifecycle lifecycle = this.service.start("resource", (State)DefaultLifecycleStates.sealed);
        lifecycle.notify(CodelistAction.REMOVE.on(lifecycle.resourceId()));
    }

    @Test(expected=IllegalStateException.class)
    public void delete() {
        Lifecycle lifecycle = this.service.start("resource");
        this.service.delete(lifecycle.resourceId());
        Assert.assertNull((Object)this.service.lifecycleOf(lifecycle.resourceId()));
    }

    @Test
    public void fullUseStory() {
        Lifecycle lc = this.service.start(this.resourceId);
        lc = this.service.lifecycleOf(this.resourceId);
        Assert.assertFalse((boolean)this.observer.observed());
        lc.notify((Action)lc.allowed().iterator().next());
        Assert.assertTrue((boolean)this.observer.observed());
    }

    @Singleton
    static class TestObserver {
        boolean observed = false;

        TestObserver() {
        }

        public boolean observed() {
            return this.observed;
        }

        public void observe(@Observes @Any LifecycleEvent event) {
            this.observed = true;
        }
    }
}

