/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.io.impl;

import java.io.OutputStream;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.cotrix.common.CommonUtils;
import org.cotrix.common.Report;
import org.cotrix.io.SerialisationService;
import org.cotrix.io.impl.SerialisationTask;
import org.cotrix.io.utils.Registry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DefaultSerialisationService
implements SerialisationService {
    private static final Logger log = LoggerFactory.getLogger(SerialisationService.class);
    private Registry<SerialisationTask<?, ?>> registry;

    @Inject
    public DefaultSerialisationService(Iterable<SerialisationTask<?, ?>> tasks) {
        CommonUtils.notNull((String)"serialisation tasks", tasks);
        this.registry = new Registry(tasks);
        log.info("configured with tasks {}", this.registry.tasks());
    }

    @Override
    public <T> void serialise(T object, OutputStream stream, SerialisationService.SerialisationDirectives<T> directives) {
        CommonUtils.notNull((String)"target object", object);
        CommonUtils.notNull((String)"stream", (Object)stream);
        CommonUtils.notNull((String)"directives", directives);
        double time = System.currentTimeMillis();
        try {
            SerialisationTask<?, ?> task = this.registry.get(directives);
            task.serialise(object, stream, directives);
            log.info("produced stream in {} secs.", (Object)time);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("cannot produce stream with directives " + directives + " (see cause)", e);
        }
        finally {
            Report current = Report.report();
            if (current != null) {
                current.close();
            }
        }
    }
}

