/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.io.tabular.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import org.cotrix.domain.attributes.Attribute;
import org.cotrix.domain.codelist.Codelist;
import org.cotrix.io.MapService;
import org.cotrix.io.tabular.map.ColumnDirectives;
import org.cotrix.io.tabular.map.MappingMode;
import org.virtualrepository.tabular.Column;

public class Table2CodelistDirectives
implements MapService.MapDirectives<Codelist> {
    private final Column column;
    private QName name;
    private String version;
    private List<Attribute> attributes = new ArrayList<Attribute>();
    private List<ColumnDirectives> columnDirectives = new ArrayList<ColumnDirectives>();
    private MappingMode mode = MappingMode.STRICT;

    public Table2CodelistDirectives(Column column) {
        this.column = column;
    }

    public Table2CodelistDirectives(QName name) {
        this(new Column(name));
    }

    public Table2CodelistDirectives(String column) {
        this(new Column(column));
    }

    public Column codeColumn() {
        return this.column;
    }

    public QName name() {
        return this.name == null ? this.column.name() : this.name;
    }

    public Table2CodelistDirectives name(QName name) {
        this.name = name;
        return this;
    }

    public Table2CodelistDirectives name(String name) {
        return this.name(new QName(name));
    }

    public List<Attribute> attributes() {
        return this.attributes;
    }

    public Table2CodelistDirectives attributes(List<Attribute> attributes) {
        this.attributes = attributes;
        return this;
    }

    public Table2CodelistDirectives attributes(Attribute ... attributes) {
        return this.attributes(Arrays.asList(attributes));
    }

    public Table2CodelistDirectives add(ColumnDirectives directive) {
        this.columns().add(directive);
        return this;
    }

    public List<ColumnDirectives> columns() {
        return this.columnDirectives;
    }

    public String version() {
        return this.version;
    }

    public Table2CodelistDirectives version(String version) {
        this.version = version;
        return this;
    }

    public Table2CodelistDirectives mode(MappingMode mode) {
        this.mode = mode;
        return this;
    }

    public MappingMode mode() {
        return this.mode;
    }
}

