/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.io.utils;

import javax.enterprise.event.Observes;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.cotrix.common.cdi.ApplicationEvents;
import org.cotrix.common.cdi.Current;
import org.cotrix.io.impl.MapTask;
import org.cotrix.io.impl.ParseTask;
import org.cotrix.io.impl.SerialisationTask;
import org.sdmx.SdmxServiceFactory;
import org.sdmxsource.sdmx.api.manager.output.StructureWriterManager;
import org.sdmxsource.sdmx.api.manager.parse.StructureParsingManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.virtualrepository.VirtualRepository;
import org.virtualrepository.impl.Repository;

public class CdiProducers {
    private static final Logger log = LoggerFactory.getLogger(CdiProducers.class);
    @Inject
    private Instance<ParseTask<?, ?>> parseTasks;
    @Inject
    private Instance<MapTask<?, ?, ?>> mapTasks;
    @Inject
    private Instance<SerialisationTask<?, ?>> serialisationTasks;

    @Produces
    public Iterable<ParseTask<Object, Object>> parseTasks() {
        return this.parseTasks;
    }

    @Produces
    public Iterable<MapTask<Object, Object, Object>> mapTasks() {
        return this.mapTasks;
    }

    @Produces
    public Iterable<SerialisationTask<Object, Object>> publishTasks() {
        return this.serialisationTasks;
    }

    @Produces
    @Singleton
    public static VirtualRepository virtualRepository() {
        return new Repository();
    }

    @Produces
    @Singleton
    @Current
    public static StructureParsingManager parser() {
        return SdmxServiceFactory.parser();
    }

    @Produces
    @Singleton
    @Current
    public static StructureWriterManager writer() {
        return SdmxServiceFactory.writer();
    }

    public static void onShutdown(@Observes ApplicationEvents.Shutdown event, VirtualRepository repository) {
        log.trace("shutting down virtual repository");
        repository.shutdown();
    }
}

