/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.engine.impl;

import java.util.Calendar;
import java.util.concurrent.Callable;
import org.cotrix.action.Action;
import org.cotrix.engine.Engine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Task<T> {
    private static Logger log = LoggerFactory.getLogger(Engine.class);
    private final Callable<T> task;
    private final Calendar created;
    private Calendar started;
    private Calendar completed;

    public static <T> Task<T> taskFor(Callable<T> function) {
        return new Task<T>(function);
    }

    private Task(Callable<T> task) {
        this.task = task;
        this.created = Calendar.getInstance();
    }

    public T execute(Action action) {
        this.started = Calendar.getInstance();
        log.info("performing {}", (Object)action);
        try {
            T t = this.task.call();
            return t;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("cannot complete task " + this.task + " for " + action, e);
        }
        finally {
            this.completed = Calendar.getInstance();
            log.info("performed {} in {} ms.", (Object)action, (Object)(this.completed.getTimeInMillis() - this.started.getTimeInMillis()));
        }
    }

    public Calendar created() {
        return this.created;
    }

    public Calendar completed() {
        return this.completed;
    }

    public Calendar started() {
        return this.started;
    }
}

