/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.domain.user;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.cotrix.action.Action;
import org.cotrix.common.CommonUtils;
import org.cotrix.domain.dsl.Roles;
import org.cotrix.domain.memory.MUser;
import org.cotrix.domain.trait.BeanOf;
import org.cotrix.domain.trait.Identified;
import org.cotrix.domain.user.FingerPrint;
import org.cotrix.domain.user.Role;

public interface User
extends Identified {
    public String name();

    public String fullName();

    public String email();

    public Collection<Action> permissions();

    public Collection<Action> directPermissions();

    public boolean can(Action var1);

    public Collection<Role> roles();

    public Collection<Role> directRoles();

    public boolean isRoot();

    public boolean is(Role var1);

    public boolean isDirectly(Role var1);

    public FingerPrint fingerprint();

    public static class Private
    extends Identified.Private<Private, State>
    implements User,
    Serializable {
        private static final long serialVersionUID = 1L;

        public Private(MUser state) {
            super(state);
            this.set(state.roles());
        }

        public Private(State state) {
            super(state);
        }

        @Override
        public String name() {
            return ((State)this.bean()).name();
        }

        @Override
        public String fullName() {
            return ((State)this.bean()).fullName();
        }

        @Override
        public String email() {
            return ((State)this.bean()).email();
        }

        private void set(Collection<Role> roles) {
            HashSet<Role> newRoles = new HashSet<Role>();
            for (Role role : roles) {
                if (role.isIn(newRoles)) continue;
                Iterator it = newRoles.iterator();
                while (it.hasNext()) {
                    if (!role.is((Role)it.next())) continue;
                    it.remove();
                }
                newRoles.add(role);
            }
            ((State)this.bean()).roles(newRoles);
        }

        @Override
        public Collection<Role> roles() {
            HashSet<Role> roles = new HashSet<Role>();
            for (Role r : ((State)this.bean()).roles()) {
                roles.addAll(r.roles());
                roles.add(r);
            }
            return roles;
        }

        @Override
        public Collection<Role> directRoles() {
            return Collections.unmodifiableCollection(((State)this.bean()).roles());
        }

        @Override
        public boolean is(Role role) {
            CommonUtils.notNull((String)"role", (Object)role);
            return role.isIn(((State)this.bean()).roles());
        }

        @Override
        public boolean isDirectly(Role role) {
            return ((State)this.bean()).roles().contains(role);
        }

        @Override
        public Collection<Action> directPermissions() {
            return Collections.unmodifiableCollection(((State)this.bean()).permissions());
        }

        public List<Action> permissions() {
            ArrayList<Action> permissions = new ArrayList<Action>(((State)this.bean()).permissions());
            for (Role role : this.roles()) {
                for (Action p : role.permissions()) {
                    if (permissions.contains(p)) continue;
                    permissions.add(p);
                }
            }
            return permissions;
        }

        @Override
        public boolean can(Action action) {
            CommonUtils.notNull((String)"action", (Object)action);
            return action.included(this.permissions());
        }

        @Override
        public boolean isRoot() {
            return this.is(Roles.ROOT);
        }

        @Override
        public void update(Private changeset) throws IllegalArgumentException, IllegalStateException {
            super.update(changeset);
            if (changeset.fullName() != null && !changeset.fullName().equals(this.fullName())) {
                ((State)this.bean()).fullName(changeset.fullName());
            }
            if (changeset.email() != null && !changeset.email().equals(this.email())) {
                ((State)this.bean()).email(changeset.email());
            }
            ((State)this.bean()).permissions(changeset.directPermissions());
            this.set(changeset.directRoles());
        }

        @Override
        public FingerPrint fingerprint() {
            return new FingerPrint(this);
        }

        public String toString() {
            return "Private [name=" + this.name() + ", fullName=" + this.fullName() + ", permissions=" + this.directPermissions() + ", roles=" + this.directRoles() + "]";
        }
    }

    public static interface State
    extends Identified.Bean,
    BeanOf<Private> {
        public String name();

        public void name(String var1);

        public String fullName();

        public void fullName(String var1);

        public String email();

        public void email(String var1);

        public Collection<Action> permissions();

        public void permissions(Collection<Action> var1);

        public Collection<Role> roles();

        public void roles(Collection<Role> var1);
    }
}

