/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.domain.memory;

import java.util.Collection;
import java.util.HashMap;
import org.cotrix.common.CommonUtils;
import org.cotrix.domain.attributes.Attribute;
import org.cotrix.domain.attributes.AttributeDefinition;
import org.cotrix.domain.attributes.CommonDefinition;
import org.cotrix.domain.codelist.Code;
import org.cotrix.domain.codelist.Codelist;
import org.cotrix.domain.codelist.DefaultVersion;
import org.cotrix.domain.codelist.Version;
import org.cotrix.domain.common.Container;
import org.cotrix.domain.common.Status;
import org.cotrix.domain.dsl.Data;
import org.cotrix.domain.links.LinkDefinition;
import org.cotrix.domain.memory.MAttrDef;
import org.cotrix.domain.memory.MCode;
import org.cotrix.domain.memory.MContainer;
import org.cotrix.domain.memory.MDescribed;
import org.cotrix.domain.memory.MLinkDef;
import org.cotrix.domain.trait.Identified;
import org.cotrix.domain.trait.Named;
import org.cotrix.domain.utils.DomainUtils;

public final class MCodelist
extends MDescribed
implements Codelist.Bean {
    private Version version;
    private Container.Bean<Code.Bean> codes = new MContainer<Code.Bean>();
    private Container.Bean<LinkDefinition.Bean> linkDefs = new MContainer<LinkDefinition.Bean>();
    private Container.Bean<AttributeDefinition.Bean> attrDefs = new MContainer<AttributeDefinition.Bean>();

    public MCodelist() {
        this.version = new DefaultVersion();
    }

    public MCodelist(String id, Status status) {
        super(id, status);
    }

    public MCodelist(Codelist.Bean other) {
        super(other);
        MDescribed clone;
        this.version(other.version());
        HashMap<String, Object> defs = new HashMap<String, Object>();
        for (AttributeDefinition.Bean bean : other.attributeDefinitions()) {
            clone = new MAttrDef(bean);
            this.attrDefs.add((AttributeDefinition.Bean)((Object)clone));
            defs.put(bean.id(), clone);
        }
        for (LinkDefinition.Bean bean : other.linkDefinitions()) {
            clone = new MLinkDef(bean);
            this.linkDefs.add((LinkDefinition.Bean)((Object)clone));
            defs.put(bean.id(), clone);
        }
        for (Code.Bean bean : other.codes()) {
            MCode copy = new MCode(bean, defs);
            copy.attributes().add(this.nameof(bean));
            copy.attributes().add(this.idof(bean));
            this.codes.add(copy);
        }
        this.attributes().add(this.versionof(other));
        this.attributes().add(this.nameof(other));
        this.attributes().add(this.idof(other));
    }

    @Override
    public Version version() {
        return this.version;
    }

    @Override
    public void version(Version version) {
        CommonUtils.notNull((String)"version", (Object)version);
        this.version = version;
    }

    @Override
    public Container.Bean<AttributeDefinition.Bean> attributeDefinitions() {
        return this.attrDefs;
    }

    @Override
    public Container.Bean<LinkDefinition.Bean> linkDefinitions() {
        return this.linkDefs;
    }

    public void attributeDefinitions(Collection<AttributeDefinition.Bean> defs) {
        CommonUtils.notNull((String)"attribute definitons", defs);
        for (AttributeDefinition.Bean type : defs) {
            this.attrDefs.add(type);
        }
    }

    public void linkDefinitions(Collection<LinkDefinition.Bean> defs) {
        CommonUtils.notNull((String)"link definitions", defs);
        for (LinkDefinition.Bean link : defs) {
            this.linkDefs.add(link);
        }
    }

    public void codes(Collection<Code.Bean> codes) {
        CommonUtils.notNull((String)"codes", codes);
        for (Code.Bean code : codes) {
            this.codes.add(code);
        }
    }

    @Override
    public Container.Bean<Code.Bean> codes() {
        return this.codes;
    }

    @Override
    public Codelist.Private entity() {
        return new Codelist.Private(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Codelist.Bean)) {
            return false;
        }
        Codelist.Bean other = (Codelist.Bean)obj;
        if (this.version == null ? other.version() != null : !this.version.equals(other.version())) {
            return false;
        }
        if (this.codes == null ? other.codes() != null : !this.codes.equals(other.codes())) {
            return false;
        }
        if (this.linkDefs == null ? other.linkDefinitions() != null : !this.linkDefs.equals(other.linkDefinitions())) {
            return false;
        }
        return !(this.attrDefs == null ? other.linkDefinitions() != null : !this.attrDefs.equals(other.linkDefinitions()));
    }

    private Attribute.Bean nameof(Named.Bean named) {
        return DomainUtils.beanOf((Attribute)Data.attribute().instanceOf(CommonDefinition.PREVIOUS_VERSION_NAME).value(named.qname().toString()).build());
    }

    private Attribute.Bean idof(Identified.Bean identified) {
        return DomainUtils.beanOf((Attribute)Data.attribute().instanceOf(CommonDefinition.PREVIOUS_VERSION_ID).value(identified.id()).build());
    }

    private Attribute.Bean versionof(Codelist.Bean versioned) {
        return DomainUtils.beanOf((Attribute)Data.attribute().instanceOf(CommonDefinition.PREVIOUS_VERSION).value(versioned.version().value()).build());
    }
}

