/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.domain.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.cotrix.common.CommonUtils;
import org.cotrix.domain.common.BeanIteratorAdapter;
import org.cotrix.domain.common.Containers;
import org.cotrix.domain.memory.MContainer;
import org.cotrix.domain.trait.BeanOf;
import org.cotrix.domain.trait.Identified;
import org.cotrix.domain.trait.Named;

public interface Container<E>
extends Containers.BaseContainer<E> {
    public boolean contains(Named var1);

    public E getFirst(Named var1);

    public Collection<E> get(Named var1);

    public static class Private<E extends Named.Private<E, B>, B extends BeanOf<E> & Named.Bean>
    implements Container<E> {
        private final Bean<B> beans;

        @SafeVarargs
        public Private(E ... es) {
            this(new MContainer());
            for (E e : es) {
                this.beans.add((Named.Bean)((Identified.Private)e).bean());
            }
        }

        public Private(Bean<B> beans) {
            CommonUtils.notNull((String)"beans", beans);
            this.beans = beans;
        }

        public Bean<B> beans() {
            return this.beans;
        }

        @Override
        public Iterator<E> iterator() {
            return new BeanIteratorAdapter(this.beans.iterator());
        }

        @Override
        public int size() {
            return this.beans.size();
        }

        @Override
        public boolean contains(String id) {
            CommonUtils.notNull((String)"id", (Object)id);
            return this.beans.contains(id);
        }

        @Override
        public E lookup(String id) {
            CommonUtils.notNull((String)"id", (Object)id);
            return this.entityOf((BeanOf)this.beans.lookup(id));
        }

        @Override
        public boolean contains(QName name) {
            CommonUtils.notNull((String)"name", (Object)name);
            return this.beans.contains(name);
        }

        @Override
        public boolean contains(Named named) {
            CommonUtils.notNull((String)"named entity", (Object)named);
            return this.contains(named.qname());
        }

        @Override
        public Collection<E> get(QName name) {
            CommonUtils.notNull((String)"name", (Object)name);
            ArrayList matches = new ArrayList();
            for (BeanOf bean : this.beans.get(name)) {
                matches.add(bean.entity());
            }
            return matches;
        }

        @Override
        public Collection<E> get(Named named) {
            return this.get(named.qname());
        }

        @Override
        public E getFirst(QName name) {
            CommonUtils.notNull((String)"name", (Object)name);
            BeanOf bean = (BeanOf)this.beans.getFirst(name);
            return this.entityOf(bean);
        }

        @Override
        public E getFirst(Named named) {
            return (E)this.getFirst(named.qname());
        }

        public void update(Private<E, B> changeset) {
            HashMap<String, Named.Private> updates = new HashMap<String, Named.Private>();
            for (Named.Private change : changeset) {
                String id = change.id();
                if (this.beans.contains(id)) {
                    if (change.status() == null) {
                        throw new IllegalArgumentException("invalid changeset:" + change.id() + " cannot be added twice");
                    }
                    switch (change.status()) {
                        case DELETED: {
                            this.beans.remove(id);
                            break;
                        }
                        case MODIFIED: {
                            updates.put(change.id(), change);
                        }
                    }
                    continue;
                }
                this.beans.add((Named.Bean)change.bean());
            }
            if (!updates.isEmpty()) {
                for (BeanOf bean : this.beans.get(updates.keySet())) {
                    ((Named.Private)bean.entity()).update((Named.Private)updates.get(((Identified)((Object)bean)).id()));
                }
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.beans == null ? 0 : this.beans.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Private)) {
                return false;
            }
            Private other = (Private)obj;
            return !(this.beans == null ? other.beans != null : !this.beans.equals(other.beans));
        }

        public String toString() {
            int maxLen = 100;
            return "[" + (this.beans != null ? this.toString(100) : null) + "]";
        }

        private String toString(int maxLen) {
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            Iterator<E> iterator = this.iterator();
            for (int i = 0; iterator.hasNext() && i < maxLen; ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(iterator.next());
            }
            builder.append("]");
            return builder.toString();
        }

        private E entityOf(B b) {
            return (E)(b == null ? null : (Named.Private)b.entity());
        }
    }

    public static interface Bean<B extends Named.Bean>
    extends Containers.BaseContainer<B> {
        public void add(B var1);

        public void remove(String var1);

        public Collection<B> get(Collection<String> var1);
    }
}

