/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.domain.attributes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.cotrix.domain.attributes.Attribute;
import org.cotrix.domain.attributes.AttributeDefinition;
import org.cotrix.domain.attributes.Facet;
import org.cotrix.domain.common.Containers;
import org.cotrix.domain.common.Range;
import org.cotrix.domain.common.Ranges;
import org.cotrix.domain.dsl.Data;
import org.cotrix.domain.dsl.grammar.AttributeDefinitionGrammar;
import org.cotrix.domain.trait.Described;
import org.cotrix.domain.trait.Named;
import org.cotrix.domain.utils.DomainConstants;
import org.cotrix.domain.utils.DomainUtils;

public enum CommonDefinition implements Named
{
    CREATED(CommonDefinition.make("created", Ranges.once), Facet.VISIBLE, Facet.PUSBLISHEABLE),
    LAST_UPDATED(CommonDefinition.make("updated"), Facet.VISIBLE, Facet.PUSBLISHEABLE),
    UPDATED_BY(CommonDefinition.make("updatedBy"), Facet.VISIBLE),
    DELETED(CommonDefinition.make("deleted"), true, new Facet[0]),
    NEW(CommonDefinition.make("new"), true, new Facet[0]),
    MODIFIED(CommonDefinition.make("modified"), true, new Facet[0]),
    INVALID(CommonDefinition.make("invalid"), true, new Facet[0]),
    PREVIOUS_VERSION(CommonDefinition.make("previous_version"), Facet.VISIBLE),
    PREVIOUS_VERSION_ID(CommonDefinition.make("previous_version_id"), new Facet[0]),
    PREVIOUS_VERSION_NAME(CommonDefinition.make("previous_version_name"), Facet.VISIBLE),
    SUPERSIDES(CommonDefinition.make("supersides"), Facet.VISIBLE);

    private static Map<String, CommonDefinition> defs;
    private static List<CommonDefinition> markers;
    private final AttributeDefinition def;
    private final boolean marker;
    private final List<Facet> facets = new ArrayList<Facet>();

    public static boolean isCommon(String name) {
        return CommonDefinition.commonDefinitionFor(name) != null;
    }

    public static boolean isCommon(String name, Facet facet) {
        return CommonDefinition.commonDefinitionFor(name) != null && CommonDefinition.commonDefinitionFor(name).is(facet);
    }

    public static boolean isCommon(QName name) {
        return CommonDefinition.isCommon(name.getLocalPart());
    }

    public static boolean isCommon(QName name, Facet facet) {
        return CommonDefinition.isCommon(name.getLocalPart(), facet);
    }

    public static CommonDefinition commonDefinitionFor(String name) {
        return defs.get(name);
    }

    public static List<CommonDefinition> markers() {
        return markers;
    }

    private CommonDefinition(AttributeDefinition def, Facet ... facets) {
        this(def, false, facets);
    }

    private CommonDefinition(AttributeDefinition def, boolean marker, Facet ... facets) {
        this.def = def;
        this.marker = marker;
        for (Facet f : facets) {
            this.facets.add(f);
        }
    }

    @Override
    public QName qname() {
        return this.def.qname();
    }

    public boolean is(Facet facet) {
        return this.facets.contains((Object)facet);
    }

    public AttributeDefinition get() {
        return this.def;
    }

    public boolean isMarker() {
        return this.marker;
    }

    public AttributeDefinition.Bean bean() {
        return (AttributeDefinition.Bean)Data.reveal(this.def).bean();
    }

    public Attribute instance() {
        return (Attribute)Data.attribute().instanceOf(this).build();
    }

    public SetTargetClause set() {
        return new SetTargetClause("TRUE");
    }

    public SetTargetClause set(String value) {
        return new SetTargetClause(value);
    }

    public CommonDefinition removeFrom(Described entity) {
        return this.removeFrom(entity.attributes());
    }

    public CommonDefinition removeFrom(Containers.Attributes as) {
        Attribute a = (Attribute)as.getFirst(this);
        if (a != null) {
            as.beans().remove(a.id());
        }
        return this;
    }

    public boolean isIn(Described entity) {
        return this.isIn(entity.attributes());
    }

    public boolean isIn(Containers.Attributes as) {
        return as.contains(this);
    }

    public String of(Described entity) {
        return this.in(entity.attributes());
    }

    public String in(Containers.Attributes as) {
        return as.valueOf(this);
    }

    public Date dateOf(Described entity) {
        return this.dateIn(entity.attributes());
    }

    public Date dateIn(Containers.Attributes as) {
        return as.dateOf(this);
    }

    public QName nameOf(Described entity) {
        return this.nameIn(entity.attributes());
    }

    public QName nameIn(Containers.Attributes as) {
        return as.nameOf(this);
    }

    private static AttributeDefinition make(String name) {
        return CommonDefinition.make(name, Ranges.atmostonce);
    }

    private static AttributeDefinition make(String name, Range range) {
        return (AttributeDefinition)((AttributeDefinitionGrammar.SecondClause)Data.attrdef().name(Data.q("http://cotrix.org", name))).is(DomainConstants.SYSTEM_TYPE).occurs(range).build();
    }

    static {
        defs = new HashMap<String, CommonDefinition>();
        ArrayList<CommonDefinition> mks = new ArrayList<CommonDefinition>();
        for (CommonDefinition def : CommonDefinition.values()) {
            defs.put(def.qname().getLocalPart(), def);
            if (!def.isMarker()) continue;
            mks.add(def);
        }
        markers = Collections.unmodifiableList(mks);
    }

    public class SetTargetClause {
        private String value;

        SetTargetClause(String value) {
            this.value = value;
        }

        public CommonDefinition on(Described entity) {
            return this.in(entity.attributes());
        }

        public CommonDefinition in(Containers.Attributes as) {
            if (!as.contains(CommonDefinition.this)) {
                as.beans().add(DomainUtils.beanOf(CommonDefinition.this.instance()));
            }
            Attribute a = (Attribute)as.getFirst(CommonDefinition.this);
            DomainUtils.beanOf(a).value(this.value);
            return CommonDefinition.this;
        }
    }
}

