/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.domain.trait;

import org.cotrix.domain.attributes.Attribute;
import org.cotrix.domain.attributes.CommonDefinition;
import org.cotrix.domain.common.Container;
import org.cotrix.domain.common.NamedContainer;
import org.cotrix.domain.common.NamedStateContainer;
import org.cotrix.domain.dsl.Codes;
import org.cotrix.domain.trait.Identified;
import org.cotrix.domain.utils.Utils;

public interface Attributed {
    public NamedContainer<? extends Attribute> attributes();

    public static abstract class Abstract<SELF extends Abstract<SELF, S>, S extends State & Identified.State>
    extends Identified.Abstract<SELF, S>
    implements Attributed {
        public Abstract(S state) {
            super((Identified.State)state);
        }

        public NamedContainer.Private<Attribute.Private, Attribute.State> attributes() {
            return Codes.namedContainer(((State)this.state()).attributes());
        }

        @Override
        public void update(SELF changeset) throws IllegalArgumentException, IllegalStateException {
            super.update(changeset);
            ((Container.Abstract)((Object)this.attributes())).update(((Abstract)changeset).attributes());
            NamedStateContainer<Attribute.State> attributes = ((State)this.state()).attributes();
            if (this.timestampIn(attributes)) {
                this.updateTimestampAndUserIn(attributes);
            } else {
                this.addTimestampAndUserTo(attributes);
            }
        }

        private boolean timestampIn(NamedStateContainer<Attribute.State> attributes) {
            return attributes.contains(CommonDefinition.UPDATE_TIME.qname());
        }

        private void updateTimestampAndUserIn(NamedStateContainer<Attribute.State> attributes) {
            attributes.lookup(CommonDefinition.UPDATE_TIME.qname()).value(Utils.time());
            attributes.lookup(CommonDefinition.UPDATED_BY.qname()).value(Utils.currentUser());
        }

        private void addTimestampAndUserTo(NamedStateContainer<Attribute.State> attributes) {
            attributes.add(Utils.stateof(Codes.attribute().with(CommonDefinition.UPDATE_TIME).value(Utils.time())));
            attributes.add(Utils.stateof(Codes.attribute().with(CommonDefinition.UPDATED_BY).value(Utils.currentUser())));
        }
    }

    public static interface State {
        public NamedStateContainer<Attribute.State> attributes();
    }
}

