/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.domain.utils;

import java.text.DateFormat;
import java.util.Calendar;
import javax.enterprise.event.Observes;
import javax.xml.namespace.QName;
import org.cotrix.common.cdi.ApplicationEvents;
import org.cotrix.common.cdi.Current;
import org.cotrix.domain.attributes.Attribute;
import org.cotrix.domain.common.Range;
import org.cotrix.domain.common.Ranges;
import org.cotrix.domain.dsl.Codes;
import org.cotrix.domain.dsl.Users;
import org.cotrix.domain.memory.AttributeMS;
import org.cotrix.domain.user.User;
import org.cotrix.domain.utils.CodeStatus;
import org.cotrix.domain.values.DefaultType;
import org.cotrix.domain.values.ValueType;
import org.cotrix.domain.version.Version;
import org.jboss.weld.context.RequestContext;

public class Constants {
    private static User currentUser;
    private static RequestContext requestContext;
    public static final String NS = "http://cotrix.org";
    public static final QName DESCRIPTION_TYPE;
    public static final QName ANNOTATION_TYPE;
    public static final QName NAME_TYPE;
    public static final QName OTHER_CODE_TYPE;
    public static final QName OTHER_TYPE;
    public static final QName defaultType;
    public static final QName[] defaultTypes;
    public static final QName SYSTEM_TYPE;
    public static final QName NAME;
    public static final QName CREATION_TIME;
    public static final QName UPDATE_TIME;
    public static final QName UPDATED_BY;
    public static final QName PREVIOUS_VERSION;
    public static final QName PREVIOUS_VERSION_ID;
    public static final QName PREVIOUS_VERSION_NAME;
    public static final QName SUPERSIDES;
    public static final QName STATUS;
    public static final ValueType defaultValueType;
    public static final Range defaultRange;
    public static final String UNDEFINED_LINK_VALUE = "_!!_undefined_!!_";
    public static final String NULL_STRING = "__ignore__";
    public static final QName NULL_QNAME;
    public static final String NO_MAIL = "no@cotrix.mail";

    public static Attribute.State timestamp(QName name) {
        return Constants.systemAttribute(name, Constants.time());
    }

    public static String time() {
        return DateFormat.getDateTimeInstance().format(Calendar.getInstance().getTime());
    }

    public static Attribute.State previousName(QName name) {
        return Constants.systemAttribute(PREVIOUS_VERSION_NAME, name.toString());
    }

    public static Attribute.State previousId(String id) {
        return Constants.systemAttribute(PREVIOUS_VERSION_ID, id);
    }

    public static Attribute.State previousVersion(Version version) {
        return Constants.systemAttribute(PREVIOUS_VERSION, version.value());
    }

    public static Attribute status(CodeStatus status) {
        return (Attribute)Constants.systemAttribute(STATUS, status.name()).entity();
    }

    public static Attribute.State updatedBy() {
        return Constants.systemAttribute(UPDATED_BY, Constants.currentUser());
    }

    public static void updatedBy(Attribute.State state) {
        state.value(Constants.currentUser());
    }

    private static String currentUser() {
        return requestContext.isActive() ? currentUser.name() : Users.cotrix.name();
    }

    private static Attribute.State systemAttribute(QName name, String value) {
        AttributeMS a = new AttributeMS();
        a.name(name);
        a.type(SYSTEM_TYPE);
        a.value(value);
        return a;
    }

    static void setUser(@Observes ApplicationEvents.Startup startup, @Current User user, @Current RequestContext context) {
        currentUser = user;
        requestContext = context;
    }

    static {
        DESCRIPTION_TYPE = Codes.q(NS, "description");
        ANNOTATION_TYPE = Codes.q(NS, "annotation");
        NAME_TYPE = Codes.q(NS, "name");
        OTHER_CODE_TYPE = Codes.q(NS, "other_code");
        OTHER_TYPE = Codes.q(NS, "other");
        defaultType = DESCRIPTION_TYPE;
        defaultTypes = new QName[]{DESCRIPTION_TYPE, ANNOTATION_TYPE, NAME_TYPE, OTHER_CODE_TYPE, OTHER_TYPE};
        SYSTEM_TYPE = Codes.q(NS, "system");
        NAME = Codes.q(NS, "name");
        CREATION_TIME = Codes.q(NS, "created");
        UPDATE_TIME = Codes.q(NS, "updated");
        UPDATED_BY = Codes.q(NS, "updatedBy");
        PREVIOUS_VERSION = Codes.q(NS, "previous_version");
        PREVIOUS_VERSION_ID = Codes.q(NS, "previous_version_id");
        PREVIOUS_VERSION_NAME = Codes.q(NS, "previous_version_name");
        SUPERSIDES = Codes.q(NS, "supersides");
        STATUS = Codes.q(NS, "status");
        defaultValueType = new DefaultType();
        defaultRange = Ranges.arbitrarily;
        NULL_QNAME = Codes.q(NULL_STRING);
    }
}

