/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.domain.utils;

import javax.xml.namespace.QName;
import org.cotrix.common.Utils;
import org.cotrix.domain.common.Attribute;
import org.cotrix.domain.dsl.Codes;
import org.cotrix.domain.utils.Constants;

public class AttributeTemplate {
    private final Attribute template;

    public AttributeTemplate(Attribute template) {
        Utils.notNull((String)"template", (Object)template);
        if (Codes.reveal(template).isChangeset()) {
            throw new IllegalArgumentException("attribute template cannot be a changeset");
        }
        this.template = template;
    }

    public QName name() {
        return this.template.name();
    }

    public QName type() {
        return this.template.type();
    }

    public String language() {
        return this.template.language();
    }

    public boolean matches(Attribute attribute) {
        return this.matches((Attribute.State)Codes.reveal(attribute).state());
    }

    public boolean matches(Attribute.State attribute) {
        return this.matches(this.template.name(), attribute.name()) && this.matches(this.template.type(), attribute.type()) && this.matches(this.template.language(), attribute.language());
    }

    private boolean matches(Object template, Object val) {
        return template == null || template.equals(Constants.NULL_QNAME) || template.equals("__ignore__") || template.equals(val);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.template == null ? 0 : this.template.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AttributeTemplate other = (AttributeTemplate)obj;
        return !(this.template == null ? other.template != null : !this.template.equals(other.template));
    }
}

