/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.domain.user;

import java.util.Collection;
import java.util.HashSet;
import org.cotrix.action.Action;
import org.cotrix.action.ResourceType;
import org.cotrix.common.Utils;
import org.cotrix.domain.user.Role;
import org.cotrix.domain.user.User;

public class DefaultRole
implements Role {
    private final User model;
    private final String resource;
    private final ResourceType type;

    public DefaultRole(User model, ResourceType type) {
        this(model, type, "*");
    }

    public DefaultRole(User model, ResourceType type, String resource) {
        Utils.notNull((String)"role model", (Object)model);
        Utils.notNull((String)"type", (Object)type);
        Utils.notNull((String)"resource", (Object)resource);
        this.model = model;
        this.type = type;
        this.resource = resource;
    }

    @Override
    public ResourceType type() {
        return this.type;
    }

    @Override
    public Role on(String resource) {
        return new DefaultRole(this.model, this.type, resource);
    }

    @Override
    public String resource() {
        return this.resource;
    }

    @Override
    public String name() {
        return this.model.name();
    }

    @Override
    public String description() {
        return this.model.fullName();
    }

    @Override
    public Collection<Role> roles() {
        return this.adaptRoles(this.model.roles());
    }

    @Override
    public Collection<Role> directRoles() {
        return this.adaptRoles(this.model.directRoles());
    }

    @Override
    public boolean is(Role role) {
        Utils.notNull((String)"role", (Object)role);
        return role.isIn(this.roles());
    }

    @Override
    public boolean isIn(Collection<Role> roles) {
        Utils.notNull((String)"roles", roles);
        for (Role r : roles) {
            if (!r.equals(this) && !r.equals(this.on("*")) && !r.is(this)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<Action> permissions() {
        return this.adaptPermissions(this.model.permissions());
    }

    @Override
    public Collection<Action> directPermissions() {
        return this.adaptPermissions(this.model.directPermissions());
    }

    private Collection<Action> adaptPermissions(Collection<Action> permissions) {
        HashSet<Action> adapted = new HashSet<Action>();
        for (Action p : permissions) {
            Action a = p.type() == this.type() ? p.on(this.resource) : p;
            adapted.add(a);
        }
        return adapted;
    }

    private Collection<Role> adaptRoles(Collection<Role> roles) {
        HashSet<Role> adapted = new HashSet<Role>();
        for (Role r : roles) {
            Role adaptedRole = r.type() == this.type() ? r.on(this.resource()) : r;
            adapted.add(adaptedRole);
        }
        return adapted;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.model == null ? 0 : this.model.hashCode());
        result = 31 * result + (this.resource == null ? 0 : this.resource.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultRole other = (DefaultRole)obj;
        if (this.model == null ? other.model != null : !this.model.equals(other.model)) {
            return false;
        }
        return !(this.resource == null ? other.resource != null : !this.resource.equals(other.resource));
    }

    public String toString() {
        return "[role=" + this.model + ", resource=" + this.resource + "]";
    }
}

