/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.common.cdi;

import java.lang.annotation.Annotation;
import javax.enterprise.event.Event;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.cotrix.common.cdi.ApplicationEvents;
import org.cotrix.common.tx.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ApplicationLifecycle {
    private static Logger log = LoggerFactory.getLogger(ApplicationLifecycle.class);
    private Event<ApplicationEvents.ApplicationEvent> events;
    private AnnotationLiteral<? extends Annotation> scenario;

    @Inject
    public ApplicationLifecycle(Event<ApplicationEvents.ApplicationEvent> events) {
        this.events = events;
    }

    @Transactional
    public void start() {
        this.scenario = new AnnotationLiteral<ApplicationEvents.FirstTime>(){};
        log.info("Cotrix is starting...");
        this.events.fire((Object)ApplicationEvents.Startup.INSTANCE);
        log.info("Cotrix is staging...({})", (Object)this.scenario.annotationType().getSimpleName());
        this.events.select(new Annotation[]{this.scenario}).fire((Object)ApplicationEvents.Ready.INSTANCE);
    }

    public void isRestart() {
        this.scenario = new AnnotationLiteral<ApplicationEvents.Restart>(){};
    }

    public void stop() {
        log.info("Cotrix is stopping...");
        this.events.fire((Object)ApplicationEvents.Shutdown.INSTANCE);
    }
}

