/*
 * Decompiled with CFR 0.152.
 */
package org.cotrix.common.tx;

import java.io.IOException;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.cotrix.common.tx.Transaction;
import org.cotrix.common.tx.Transactions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionalFilter
implements Filter {
    private static Logger log = LoggerFactory.getLogger(TransactionalFilter.class);
    @Inject
    Transactions txs;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String path = ((HttpServletRequest)HttpServletRequest.class.cast(request)).getRequestURI();
        log.trace("start transaction for request @ {} ", (Object)path);
        try (Transaction tx = this.txs.open();){
            chain.doFilter(request, response);
            log.trace("committing  transaction for request @ {} ", (Object)path);
            tx.commit();
        }
    }

    public void destroy() {
    }
}

