/*
 * Decompiled with CFR 0.152.
 */
package org.acme;

import javax.inject.Inject;
import org.cotrix.action.Action;
import org.cotrix.action.Actions;
import org.cotrix.action.ResourceType;
import org.cotrix.application.DelegationPolicy;
import org.cotrix.application.PermissionDelegationService;
import org.cotrix.application.impl.delegation.DefaultDelegationService;
import org.cotrix.domain.dsl.Roles;
import org.cotrix.domain.dsl.Users;
import org.cotrix.domain.user.Role;
import org.cotrix.domain.user.User;
import org.cotrix.repository.UserRepository;
import org.cotrix.test.ApplicationTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class PermissionDelegationTest
extends ApplicationTest {
    static Action doit = Actions.action((String)"doit", (String[])new String[0]);
    PermissionDelegationService service;
    @Inject
    UserRepository repository;
    DelegationPolicy policy;

    @Before
    public void setup() {
        this.policy = (DelegationPolicy)Mockito.mock(DelegationPolicy.class);
        User current = Users.user().name("current").fullName("current").email("current@me.com").build();
        this.service = new DefaultDelegationService(current, this.repository, this.policy);
    }

    @Test
    public void delegatesExistingPermission() {
        User bill = this.billCan(doit);
        this.service.delegate(new Action[]{doit}).to(bill);
        Assert.assertEquals((long)1L, (long)bill.permissions().size());
    }

    @Test
    public void delegatesExistingRole() {
        Role role = this.aRole();
        User bill = this.billIs(role);
        this.service.delegate(new Role[]{role}).to(bill);
        Assert.assertEquals((long)1L, (long)bill.roles().size());
    }

    @Test(expected=IllegalStateException.class)
    public void doesNotRevokeNotExistentPermission() {
        User bill = Users.user().name("bill").fullName("bill").noMail().build();
        this.repository.add((Object)bill);
        this.service.revoke(new Action[]{doit}).from(bill);
    }

    @Test
    public void consultsPolicyForDelegation() {
        User bill = this.bill();
        this.service.delegate(new Action[]{doit}).to(bill);
        ((DelegationPolicy)Mockito.verify((Object)this.policy)).validateDelegation((User)Mockito.any(User.class), (User)Mockito.any(User.class), (Action[])Mockito.anyVararg());
    }

    @Test
    public void consultsPolicyForRevocation() {
        User bill = this.billCan(doit);
        this.service.revoke(new Action[]{doit}).from(bill);
        ((DelegationPolicy)Mockito.verify((Object)this.policy)).validateRevocation((User)Mockito.any(User.class), (User)Mockito.any(User.class), (Action[])Mockito.anyVararg());
    }

    @Test
    public void persistsDelegation() {
        User bill = this.bill();
        this.service.delegate(new Action[]{doit}).to(bill);
        User billAsRetrieved = (User)this.repository.lookup(bill.id());
        Assert.assertTrue((boolean)billAsRetrieved.can(doit));
    }

    @Test
    public void persistsRoleDelegation() {
        Role role = this.aRole();
        User bill = this.bill();
        this.service.delegate(new Role[]{role}).to(bill);
        User billAsRetrieved = (User)this.repository.lookup(bill.id());
        Assert.assertTrue((boolean)billAsRetrieved.is(role));
    }

    @Test
    public void persistsRevocation() {
        User bill = Users.user().name("bill").fullName("bill").email("bill@me.com").can(new Action[]{doit}).build();
        this.repository.add((Object)bill);
        this.service.revoke(new Action[]{doit}).from(bill);
        User billAsRetrieved = (User)this.repository.lookup(bill.id());
        Assert.assertFalse((boolean)billAsRetrieved.can(doit));
    }

    @Test
    public void rolesAreRevoked() {
        Role role1 = this.aRole();
        Role role2 = this.aRole();
        User bill = this.billIs(role1, role2);
        this.service.revoke(new Role[]{role2}).from(bill);
        User billAsRetrieved = (User)this.repository.lookup(bill.id());
        Assert.assertFalse((boolean)billAsRetrieved.is(role2));
    }

    @Test
    public void revokingLastRoleRemovesUser() {
        Role role = this.aRole();
        User bill = this.billIs(role);
        this.service.revoke(new Role[]{role}).from(bill);
        Assert.assertNull((Object)this.repository.lookup(bill.id()));
    }

    @Test
    public void revokingARolePreservesItsParents() {
        Role parent = Roles.role((String)"parent").buildAsRoleFor(ResourceType.application);
        Role child = Roles.role((String)"child").is(new Role[]{parent}).buildAsRoleFor(ResourceType.application);
        User bill = this.billIs(child);
        this.service.revoke(new Role[]{child}).from(bill);
        User billAsRetrieved = (User)this.repository.lookup(bill.id());
        Assert.assertFalse((boolean)billAsRetrieved.is(child));
        Assert.assertTrue((boolean)billAsRetrieved.is(parent));
    }

    private User bill() {
        User bill = Users.user().name("bill").fullName("bill").email("bill@me.com").build();
        this.repository.add((Object)bill);
        return bill;
    }

    private User billCan(Action ... actions) {
        User bill = Users.user().name("bill").fullName("bill").email("bill@me.com").can(actions).build();
        this.repository.add((Object)bill);
        return bill;
    }

    private User billIs(Role ... roles) {
        User bill = Users.user().name("bill").fullName("bill").email("bill@me.com").is(roles).build();
        this.repository.add((Object)bill);
        return bill;
    }

    private Role aRole() {
        return Users.user().name("role").fullName("role").noMail().buildAsRoleFor(ResourceType.application);
    }
}

