/*
 * Decompiled with CFR 0.152.
 */
package org.acme;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.xml.namespace.QName;
import org.cotrix.action.events.CodelistActionEvents;
import org.cotrix.application.NewsService;
import org.cotrix.test.ApplicationTest;
import org.junit.Assert;
import org.junit.Test;

public class NewsServiceTest
extends ApplicationTest {
    static NewsService.NewsItem testItem = new NewsService.NewsItem("text");
    @Inject
    NewsService service;
    @Inject
    TestReporter reporter;
    @Inject
    Event<CodelistActionEvents.CodelistEvent> actions;

    @Test
    public void publishNews() {
        this.reporter.fire(testItem);
        Collection news = this.service.news();
        Assert.assertTrue((boolean)news.contains(testItem));
    }

    @Test
    public void getRecentNews() throws Exception {
        this.reporter.fire(new NewsService.NewsItem("some"));
        this.reporter.fire(new NewsService.NewsItem("some more"));
        Collection news = this.service.news();
        System.out.println(news);
        Thread.sleep(100L);
        Calendar now = Calendar.getInstance();
        NewsService.NewsItem latest = new NewsService.NewsItem("latest");
        this.reporter.fire(latest);
        news = this.service.newsSince(now);
        System.out.println(news);
        Assert.assertEquals(Arrays.asList(latest), (Object)news);
    }

    @Test
    public void publishCodelistActions() {
        int size = this.service.news().size();
        this.actions.fire((Object)new CodelistActionEvents.Import("somerepo", "id", new QName("name"), "1", null));
        System.out.println(this.service.news());
        Assert.assertEquals((long)(size + 1), (long)this.service.news().size());
    }

    static class TestReporter {
        @Inject
        Event<NewsService.NewsItem> news;

        TestReporter() {
        }

        void fire(NewsService.NewsItem item) {
            this.news.fire((Object)item);
        }
    }
}

