/*
 * Decompiled with CFR 0.152.
 */
package smallgears.virtualrepository.impl;

import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smallgears.api.Apikit;
import smallgears.virtualrepository.Asset;
import smallgears.virtualrepository.Repository;
import smallgears.virtualrepository.VirtualRepository;
import smallgears.virtualrepository.common.Constants;
import smallgears.virtualrepository.impl.DefaultVirtualRepository;
import smallgears.virtualrepository.spi.VirtualWriter;

public class PublicationCompanion {
    private static final Logger log = LoggerFactory.getLogger((String)"virtual-repository");
    @NonNull
    DefaultVirtualRepository vr;

    VirtualRepository.ContentCheckClause canPublish(Asset asset) {
        return api -> this.writerFor(asset, api).isPresent();
    }

    VirtualRepository.PublishWithClause publish(final Asset asset) {
        return new VirtualRepository.PublishWithClause(){

            @Override
            public VirtualRepository.PublishModeClause with(final Object content) {
                return new VirtualRepository.PublishModeClause(){
                    Duration timeout = Constants.default_publish_timeout;

                    @Override
                    public VirtualRepository.PublishModeClause timeout(Duration to) {
                        this.timeout = to;
                        return this;
                    }

                    @Override
                    public void blocking() {
                        Future future = PublicationCompanion.this.publish(asset, content);
                        VirtualRepository.PublicationObserver dummyObserver = new VirtualRepository.PublicationObserver(){};
                        this._blocking(future, dummyObserver);
                    }

                    @Override
                    public Future<?> withoutBlocking() {
                        return PublicationCompanion.this.publish(asset, content);
                    }

                    @Override
                    public void notifying(VirtualRepository.PublicationObserver observer) {
                        Future future = PublicationCompanion.this.publish(asset, content);
                        PublicationCompanion.this.vr.executor().submit(() -> this._blocking(future, observer));
                    }

                    private void _blocking(Future<?> future, VirtualRepository.PublicationObserver observer) {
                        try {
                            future.get(this.timeout.toMillis(), TimeUnit.MILLISECONDS);
                            observer.onSuccess();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            observer.onError(e);
                            throw Apikit.unchecked((Throwable)e);
                        }
                        catch (ExecutionException | TimeoutException e) {
                            Throwable t = e instanceof ExecutionException ? e.getCause() : e;
                            observer.onError(t);
                            Apikit.rethrow((String)String.format("cannot publish content for asset %s to repository service %s", asset.name(), asset.repository().name()), (Throwable)t);
                        }
                    }
                };
            }
        };
    }

    private Future<?> publish(final Asset asset, final Object content) {
        Repository repo = asset.repository();
        Class<?> api = content.getClass();
        final VirtualWriter<?> writer = this.writerFor(asset, api).orElseThrow(() -> new IllegalStateException(String.format("cannot publis asset %s from %s: no publisher for api %s", asset.id(), repo, api)));
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    long time = System.currentTimeMillis();
                    log.info("publishing asset {} to {}", (Object)asset.name(), (Object)asset.repository().name());
                    writer.publish(asset, content);
                    log.info("published asset {} to {} in {} ms.", new Object[]{asset.name(), asset.repository().name(), System.currentTimeMillis() - time});
                }
                catch (Exception e) {
                    Apikit.rethrow((Throwable)e);
                }
            }
        };
        return this.vr.executor().submit(task);
    }

    private <A> Optional<VirtualWriter<A>> writerFor(Asset asset, Class<A> api) {
        if (asset.repository() == null) {
            throw new IllegalArgumentException(String.format("asset %s is not bound to a repository, hence cannot be published.", asset.name()));
        }
        List<VirtualWriter<?>> basewriters = asset.repository().proxy().writers();
        return this.vr.transforms().inferWriter(basewriters, asset.type(), api);
    }

    @ConstructorProperties(value={"vr"})
    public PublicationCompanion(@NonNull DefaultVirtualRepository vr) {
        if (vr == null) {
            throw new IllegalArgumentException("vr is null");
        }
        this.vr = vr;
    }
}

