/*
 * Decompiled with CFR 0.152.
 */
package smallgears.virtualrepository.impl;

import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smallgears.virtualrepository.Asset;
import smallgears.virtualrepository.AssetType;
import smallgears.virtualrepository.Repositories;
import smallgears.virtualrepository.Repository;
import smallgears.virtualrepository.VirtualRepository;
import smallgears.virtualrepository.common.Constants;
import smallgears.virtualrepository.impl.DefaultVirtualRepository;

public class DiscoveryCompanion {
    private static final Logger log = LoggerFactory.getLogger((String)"virtual-repository");
    @NonNull
    DefaultVirtualRepository vr;

    public VirtualRepository.DiscoverClause discover(final @NonNull Collection<AssetType> types) {
        if (types == null) {
            throw new IllegalArgumentException("types is null");
        }
        return new VirtualRepository.DiscoverClause(){
            Duration timeout = Constants.default_discovery_timeout;
            Repositories repos;
            {
                this.repos = DiscoveryCompanion.this.vr.repositories();
            }

            @Override
            public VirtualRepository.DiscoverClause timeout(Duration to) {
                this.timeout = to;
                return this;
            }

            @Override
            public VirtualRepository.DiscoverClause over(Repositories repositories) {
                this.repos = repositories;
                return this;
            }

            @Override
            public int blocking() {
                VirtualRepository.DiscoveryObserver dummyObserver = new VirtualRepository.DiscoveryObserver(){};
                return DiscoveryCompanion.this.discover(this.timeout, (Iterable)((Object)this.repos), types, dummyObserver);
            }

            @Override
            public Future<Integer> withoutBlocking() {
                return DiscoveryCompanion.this.vr.executor().submit(() -> this.blocking());
            }

            @Override
            public void notifying(@NonNull VirtualRepository.DiscoveryObserver observer) {
                if (observer == null) {
                    throw new IllegalArgumentException("observer is null");
                }
                DiscoveryCompanion.this.vr.executor().submit(() -> DiscoveryCompanion.this.discover(this.timeout, (Iterable)((Object)this.repos), types, observer));
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int discover(Duration timeout, @NonNull Iterable<Repository> repositories, Collection<AssetType> types, VirtualRepository.DiscoveryObserver observer) {
        if (repositories == null) {
            throw new IllegalArgumentException("repositories is null");
        }
        ExecutorCompletionService<Collection<Asset>> service = new ExecutorCompletionService<Collection<Asset>>(this.vr.executor());
        log.info("discovering assets of types {}", types);
        long time = System.currentTimeMillis();
        ArrayList<DiscoveryTask> submitted = new ArrayList<DiscoveryTask>();
        for (Repository repo : repositories) {
            List<AssetType> disseminated = repo.disseminated(types);
            if (disseminated.isEmpty()) continue;
            DiscoveryTask task = new DiscoveryTask(repo, disseminated);
            service.submit(task);
            submitted.add(task);
        }
        int completed = 0;
        int news = 0;
        int refreshed = 0;
        for (DiscoveryTask task : submitted) {
            try {
                Future nextResults = service.poll(timeout.toMillis(), TimeUnit.MILLISECONDS);
                if (nextResults == null) {
                    log.warn("asset discovery timed out after succesful interaction with {} service(s)", (Object)completed);
                    break;
                }
                Map<String, Asset> map = this.vr.assets();
                synchronized (map) {
                    for (Asset a : (Collection)nextResults.get()) {
                        a.repository(task.repo);
                        if (this.vr.assets().put(a.id(), a) == null) {
                            ++news;
                            try {
                                observer.onNext(a);
                            }
                            catch (Throwable ignoreObserverIssue) {}
                            continue;
                        }
                        ++refreshed;
                    }
                }
                ++completed;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.warn("asset discovery was interrupted after succesful interaction with {} service(s)", (Object)completed);
                break;
            }
            catch (ExecutionException e) {
                log.warn("cannot discover assets from " + task.repo.name(), e.getCause());
            }
        }
        observer.onCompleted();
        log.info("discovered {} new asset(s) of type(s) {} (refreshed {}, total {}) in {} ms.", new Object[]{news, types, refreshed, this.vr.size(), System.currentTimeMillis() - time});
        return news;
    }

    @ConstructorProperties(value={"vr"})
    public DiscoveryCompanion(@NonNull DefaultVirtualRepository vr) {
        if (vr == null) {
            throw new IllegalArgumentException("vr is null");
        }
        this.vr = vr;
    }

    private class DiscoveryTask
    implements Callable<Collection<Asset>> {
        @NonNull
        final Repository repo;
        @NonNull
        Collection<AssetType> types;

        @Override
        public Collection<Asset> call() {
            try {
                log.info("discovering assets of types {} from {}", this.types, (Object)this.repo.name());
                long time = System.currentTimeMillis();
                Collection<Asset> discovered = this.repo.proxy().browser().discover(this.types);
                log.info("discovered {} asset(s) of types {} from {} in {} ms. ", new Object[]{discovered.size(), this.types, this.repo.name(), System.currentTimeMillis() - time});
                return discovered;
            }
            catch (Exception e) {
                log.warn("cannot discover assets from " + this.repo.name(), (Throwable)e);
                return Collections.emptyList();
            }
        }

        @ConstructorProperties(value={"repo", "types"})
        public DiscoveryTask(@NonNull Repository repo, Collection<AssetType> types) {
            if (repo == null) {
                throw new IllegalArgumentException("repo is null");
            }
            if (types == null) {
                throw new IllegalArgumentException("types is null");
            }
            this.repo = repo;
            this.types = types;
        }
    }
}

