/*
 * Decompiled with CFR 0.152.
 */
package smallgears.virtualrepository.impl;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smallgears.virtualrepository.Asset;
import smallgears.virtualrepository.AssetType;
import smallgears.virtualrepository.Repositories;
import smallgears.virtualrepository.VirtualRepository;
import smallgears.virtualrepository.common.Utils;
import smallgears.virtualrepository.impl.DiscoveryCompanion;
import smallgears.virtualrepository.impl.Extensions;
import smallgears.virtualrepository.impl.PublicationCompanion;
import smallgears.virtualrepository.impl.RetrievalCompanion;
import smallgears.virtualrepository.impl.Transforms;

public class DefaultVirtualRepository
implements VirtualRepository {
    private static final Logger log = LoggerFactory.getLogger((String)"virtual-repository");
    @NonNull
    private Repositories repositories;
    @NonNull
    private Extensions extensions;
    private DiscoveryCompanion discoveryCompanion = new DiscoveryCompanion(this);
    private RetrievalCompanion retrievalCompanion = new RetrievalCompanion(this);
    private PublicationCompanion publicationCompanion = new PublicationCompanion(this);
    private Map<String, Asset> assets = new HashMap<String, Asset>();
    private ExecutorService executor = Executors.newCachedThreadPool();

    @Override
    public int size() {
        return this.assets.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<Asset> iterator() {
        Map<String, Asset> map = this.assets;
        synchronized (map) {
            return new ArrayList<Asset>(this.assets.values()).iterator();
        }
    }

    @Override
    public Transforms transforms() {
        return this.extensions.transforms();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<Asset> lookup(@NonNull String id) {
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        Map<String, Asset> map = this.assets;
        synchronized (map) {
            return Optional.ofNullable(this.assets.get(id));
        }
    }

    @Override
    public List<Asset> lookup(@NonNull AssetType type) {
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        return this.stream().filter(a -> Utils.ordered(a.type(), type)).collect(Collectors.toList());
    }

    @Override
    public Map<AssetType, List<Asset>> lookup(AssetType ... types) {
        if (types == null) {
            throw new IllegalArgumentException("types is null");
        }
        HashMap<AssetType, List<Asset>> assets = new HashMap<AssetType, List<Asset>>();
        for (AssetType type : types) {
            assets.put(type, new ArrayList());
        }
        Iterator<Asset> iterator = this.iterator();
        while (iterator.hasNext()) {
            Asset asset = (Asset)iterator.next();
            List assetsByType = (List)assets.get(asset.type());
            if (assetsByType == null) continue;
            assetsByType.add(asset);
        }
        return assets;
    }

    @Override
    public VirtualRepository.DiscoverClause discover(@NonNull Collection<AssetType> types) {
        if (types == null) {
            throw new IllegalArgumentException("types is null");
        }
        return this.discoveryCompanion.discover(types);
    }

    @Override
    public VirtualRepository.ContentCheckClause canRetrieve(Asset asset) {
        return this.retrievalCompanion.canRetrieve(asset);
    }

    @Override
    public VirtualRepository.RetrieveAsClause retrieve(@NonNull Asset asset) {
        if (asset == null) {
            throw new IllegalArgumentException("asset is null");
        }
        return this.retrievalCompanion.retrieve(asset);
    }

    @Override
    public VirtualRepository.ContentCheckClause canPublish(Asset asset) {
        return this.publicationCompanion.canPublish(asset);
    }

    @Override
    public VirtualRepository.PublishWithClause publish(Asset asset) {
        return this.publicationCompanion.publish(asset);
    }

    @Override
    public void shutdown() {
        try {
            log.info("shutting down...");
            this.executor.shutdown();
            this.executor.awaitTermination(3000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            log.warn("no clean shutdown (see cause)", (Throwable)e);
        }
        this.repositories.shutdown();
        this.extensions.shutdown();
    }

    @ConstructorProperties(value={"repositories", "extensions"})
    public DefaultVirtualRepository(@NonNull Repositories repositories, @NonNull Extensions extensions) {
        if (repositories == null) {
            throw new IllegalArgumentException("repositories is null");
        }
        if (extensions == null) {
            throw new IllegalArgumentException("extensions is null");
        }
        this.repositories = repositories;
        this.extensions = extensions;
    }

    @Override
    @NonNull
    public Repositories repositories() {
        return this.repositories;
    }

    @Override
    @NonNull
    public Extensions extensions() {
        return this.extensions;
    }

    public Map<String, Asset> assets() {
        return this.assets;
    }

    public DefaultVirtualRepository executor(ExecutorService executor) {
        this.executor = executor;
        return this;
    }

    public ExecutorService executor() {
        return this.executor;
    }
}

