/*
 * Decompiled with CFR 0.152.
 */
package smallgears.virtualrepository;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import lombok.NonNull;
import smallgears.virtualrepository.Asset;
import smallgears.virtualrepository.AssetType;
import smallgears.virtualrepository.Repositories;
import smallgears.virtualrepository.Repository;
import smallgears.virtualrepository.VirtualRepository;
import smallgears.virtualrepository.impl.DefaultVirtualRepository;
import smallgears.virtualrepository.impl.Extensions;
import smallgears.virtualrepository.impl.Transforms;
import smallgears.virtualrepository.spi.Transform;
import smallgears.virtualrepository.spi.VirtualExtension;

public final class VR {
    public static Repositories repositories(Repository ... repositories) {
        if (repositories == null) {
            throw new IllegalArgumentException("repositories is null");
        }
        return new Repositories(repositories);
    }

    public static Repositories repositories(@NonNull Iterable<Repository> repositories) {
        if (repositories == null) {
            throw new IllegalArgumentException("repositories is null");
        }
        return new Repositories(repositories);
    }

    public static Transforms transforms(Transform<?, ?> ... transforms) {
        if (transforms == null) {
            throw new IllegalArgumentException("transforms is null");
        }
        return new Transforms(transforms);
    }

    public static Extensions extensions(VirtualExtension ... extensions) {
        return new Extensions(extensions);
    }

    public static VirtualRepository repository() {
        return new DefaultVirtualRepository(VR.repositories(new Repository[0]).load(), VR.extensions(new VirtualExtension[0]).load());
    }

    public static VirtualRepository repositoryWith(Repository repo, Repository ... repositories) {
        ArrayList<Repository> repos = new ArrayList<Repository>();
        repos.add(repo);
        repos.addAll(Arrays.asList(repositories));
        return new DefaultVirtualRepository(VR.repositories(repos), VR.extensions(new VirtualExtension[0]));
    }

    public static VirtualRepository repository(@NonNull Repositories repositories, @NonNull Extensions extensions) {
        if (repositories == null) {
            throw new IllegalArgumentException("repositories is null");
        }
        if (extensions == null) {
            throw new IllegalArgumentException("extensions is null");
        }
        return new DefaultVirtualRepository(repositories, extensions);
    }

    public static AssetNameClause asset() {
        return VR.asset(UUID.randomUUID().toString());
    }

    public static AssetNameClause asset(@NonNull String id) {
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        return x0 -> {
            class Clause
            implements AssetClause {
                @NonNull
                String name;
                AssetType type = AssetType.any;
                final /* synthetic */ String val$id;

                @Override
                public AssetClause of(@NonNull AssetType type) {
                    if (type == null) {
                        throw new IllegalArgumentException("type is null");
                    }
                    this.type = type;
                    return this;
                }

                @Override
                public Asset in(@NonNull Repository repo) {
                    if (repo == null) {
                        throw new IllegalArgumentException("repo is null");
                    }
                    return new Asset(this.type, this.val$id, this.name, repo);
                }

                @Override
                public Asset justDiscovered() {
                    return new Asset(this.type, this.val$id, this.name);
                }

                public Clause(@NonNull String name, String string) {
                    this.val$id = string;
                    if (name == null) {
                        throw new IllegalArgumentException("name is null");
                    }
                    this.name = name;
                }
            }
            return new Clause(x0, id);
        };
    }

    public static <A extends Asset> SourceApiClause transform(final @NonNull AssetType type) {
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        return new SourceApiClause(){

            @Override
            public <S> TargetApiClause<S> from(final @NonNull Class<S> sourceapi) {
                if (sourceapi == null) {
                    throw new IllegalArgumentException("sourceapi is null");
                }
                return new TargetApiClause<S>(){

                    @Override
                    public <T> TransformClause<S, T> to(final @NonNull Class<T> targetapi) {
                        if (targetapi == null) {
                            throw new IllegalArgumentException("targetapi is null");
                        }
                        return new TransformClause<S, T>(){

                            @Override
                            public Transform<S, T> with(final @NonNull BiFunction<Asset, S, T> transform) {
                                if (transform == null) {
                                    throw new IllegalArgumentException("transform is null");
                                }
                                return new Transform<S, T>(){

                                    @Override
                                    public T apply(Asset asset, S input) throws Exception {
                                        return transform.apply(asset, input);
                                    }

                                    @Override
                                    public AssetType type() {
                                        return type;
                                    }

                                    @Override
                                    public Class<S> sourceApi() {
                                        return sourceapi;
                                    }

                                    @Override
                                    public Class<T> targetApi() {
                                        return targetapi;
                                    }

                                    public String toString() {
                                        return String.format("%s:%s-to-%s", this.type().name(), this.sourceApi().getSimpleName(), this.targetApi().getSimpleName());
                                    }
                                };
                            }
                        };
                    }
                };
            }
        };
    }

    private VR() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static interface TransformClause<S, T> {
        public Transform<S, T> with(BiFunction<Asset, S, T> var1);

        default public Transform<S, T> with(Function<S, T> transform) {
            return this.with((Asset __, S stream) -> transform.apply(stream));
        }
    }

    public static interface TargetApiClause<S> {
        public <T> TransformClause<S, T> to(Class<T> var1);
    }

    public static interface SourceApiClause {
        public <S> TargetApiClause<S> from(Class<S> var1);
    }

    public static interface AssetClause {
        public AssetClause of(AssetType var1);

        default public AssetClause of(String type) {
            return this.of(AssetType.of(type));
        }

        public Asset in(Repository var1);

        public Asset justDiscovered();
    }

    public static interface AssetNameClause {
        public AssetClause name(String var1);
    }
}

