/*
 * Decompiled with CFR 0.152.
 */
package smallgears.api.tabular.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import smallgears.api.tabular.Column;
import smallgears.api.tabular.Row;
import smallgears.api.tabular.Table;
import smallgears.api.tabular.impl.AbstractTable;
import smallgears.api.tabular.utils.MaterialisedTable;

public class SimpleTable
extends AbstractTable
implements MaterialisedTable {
    private final List<Row> rows = new ArrayList<Row>();

    public SimpleTable(List<Column> columns, @NonNull Iterable<Row> rows) {
        super(columns);
        if (rows == null) {
            throw new IllegalArgumentException("rows is null");
        }
        rows.forEach(r -> this.rows.add((Row)r));
    }

    public SimpleTable(Table table) {
        this(table.columns(), table.stream().collect(Collectors.toList()));
    }

    @Override
    public Iterator<Row> iterator() {
        return this.rows.iterator();
    }

    @Override
    public MaterialisedTable add(Row ... rows) {
        return this.add(Arrays.asList(rows));
    }

    @Override
    public MaterialisedTable add(Iterable<Row> rows) {
        rows.forEach(r -> this.rows.add((Row)r));
        return this;
    }

    @Override
    public MaterialisedTable remove(Iterable<Row> rows) {
        rows.forEach(r -> this.rows.remove(r));
        return this;
    }

    @Override
    public MaterialisedTable remove(Row ... rows) {
        return this.remove(Arrays.asList(rows));
    }

    @Override
    public int size() {
        return this.rows.size();
    }

    @Override
    public String toString() {
        return "SimpleTable(super=" + super.toString() + ", " + this.rows + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleTable)) {
            return false;
        }
        SimpleTable other = (SimpleTable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<Row> this$rows = this.rows;
        List<Row> other$rows = other.rows;
        return !(this$rows == null ? other$rows != null : !((Object)this$rows).equals(other$rows));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SimpleTable;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        List<Row> $rows = this.rows;
        result = result * 59 + ($rows == null ? 0 : ((Object)$rows).hashCode());
        return result;
    }
}

